

#ifndef _scrolbar_h_
#define _scrolbar_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// ScrollBar is a SimpleVObject representing a scroll bar.
// The model for a ScrollBar (the value returned by its {\tt Model} method)
// is an Interval, which is really a sub-interval
// of the Interval representing the ScrollBar's range. The ScrollBar does
// not define a selection.
//
// The ScrollBar object maintains a set of
// clients that are notified of scrolling events (see {\tt event.h}
// for the kinds of scrolling events supported).
//
// ScrollBar is an abstract class that factors out common behavior. Only the
// derived  concrete classes VScrollBar  and HScrollBar may be instantiated.


#if defined(__GNUC__)
#pragma interface
#endif


#include "base/clntset.h"

#include "ui/simple.h"
#include "ui/interval.h"
#include "ui/point.h"
#include "ui/color.h"


class YACL_UI YVE_Window;
class YACL_UI UI_DrawingSurface;
class YACL_UI UI_DwgSurfaceInMemory;


class YACL_UI UI_ScrollBar: public UI_SimpleVObject {

public:

    CL_Interval& Range ();
    // Return the current extent (i.e., the total range) of the scroll
    // bar. The application may modify  the return value using Interval's
    // methods.
    
    long& LineAmount ();
    // Return the amount to scroll by when the line-down/line-up key or
    // button is used. The return value is a reference and therefore may be
    // modified by the caller.

    long& PageAmount ();
    // Return the amount to scroll by when the ``page-by'' key or button
    // is used. The return value is a reference and therefore may be
    // modified by the caller.

    CL_ClientSet& ClientSet ();
    // Return the set of clients for this scroll bar. The application may
    // add to or remove from this Set, since this method returns a reference.

    bool& SmoothScroll ();
    // Return the ``smooth scrolling'' parameter for this scroll bar. If this
    // parameter is TRUE, the scroll bar notifies its clients on every
    // scrolling (mouse) event; if it is FALSE, the notification occurs only
    // when the mouse movement is completed.
    
    
    //-------------Inherited SimpleVObject methods---------------


    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName () const { return "UI_ScrollBar";};

protected:

    //
    //------------------Construction-------------------
    //


    UI_ScrollBar (UI_VisualObject* parent, const UI_Rectangle& shape,
                  UI_ViewID id = -1, long style = -1, bool vertical = TRUE);
    // Constructor.

    virtual ~UI_ScrollBar () = 0;
    // The destructor is pure virtual to make this an abstract class.

    void _PrivateInitialize ();
    // Overrides the inherited method. The implementation  sets up the
    // range, line and page sizes. Under X windows, it also sets up the
    // Motif resources.

    bool HandleEvent (UI_Event* e);
    // Override the inherited method. The implementation handles
    // scrolling events and notifies clients.

    bool _ModelChanged ();
    // Tell this object that the application has changed its model.

    virtual bool _RangeChanged ();
    // Tell this object that the application has changed its range (the
    // object returned by the {\tt Range} method).

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    virtual void _SetPosition (long pos);
    // [MS-Windows-specific, YACL internal use only]

    virtual void _SetRange ();
    // [MS-Windows-specific, YACL internal use only]

#elif defined(__X_YACL__)
    long                   _scaleFactorNumerator;   // Ugly. Can't use float
    long                   _scaleFactorDenominator; // -- probs under GCC
                                                    // under solaris
    short                  _sliderPos;
    short                  _sliderSize;
    UI_Rectangle           _sliderRect;
    bool                   _mouseIsDown;
    short                  _offset;
    YVE_Window*            _visualElement;
    UI_DwgSurfaceInMemory* _memDS;
    UI_Color               _gutterColor; // Hard-wired, for now
    
    
    bool MakeVisualElement ();
    
    void _Draw (UI_DrawingSurface&);
    // Draw the visual representation of this scroll bar.

    void _DrawSlider (UI_DrawingSurface&, const UI_Point&);
    // Draw the slider.

    void _ConfigureSlider ();

    void _AddToModel (short amnt);

    void _AdjustModel ();
    
    void _RedrawSlider ();
    
#endif

    CL_Interval   _range;
    CL_ClientSet  _clientSet;
    long          _lineAmount;
    long          _pageAmount;
    bool          _smoothScroll;
    bool          _vertical;

    
private:
#if defined(__X_MOTIF__)
    static void ScrollBarCallback (struct _WidgetRec*, void *, void *);
    // [X/Motif-specific, for YACL internal use only.] The Motif callback
    // method.
    
#endif
};



// VScrollBar specializes Scrollbar to represent a vertical scroll bar.

class YACL_UI UI_VScrollBar: public UI_ScrollBar {

public:


    // ------------------Construction-------------------
    UI_VScrollBar (UI_VisualObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style = -1);
    // Constructor: create a vertical scroll bar with shape {\tt shape}, as
    // a child of {\tt parent} and view id {\tt id}.

    const char* ClassName () const {return "UI_VScrollBar";};

protected:

    ~UI_VScrollBar () {};

};


// HScrollBar specializes Scrollbar to represent a horizontal scroll bar.

class YACL_UI UI_HScrollBar: public UI_ScrollBar {

public:

    // ------------------Construction-------------------
    
    UI_HScrollBar (UI_VisualObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1, long style = -1);
    // Constructor: create a horizontal scroll bar with shape {\tt shape}, as
    // a child of {\tt parent} and view id {\tt id}.

    const char* ClassName () const {return "UI_HScrollBar";};

protected:

    ~UI_HScrollBar () {};

};




inline long& UI_ScrollBar::LineAmount ()
{
    return _lineAmount;
}



inline long& UI_ScrollBar::PageAmount ()
{
    return _pageAmount;
}


inline CL_ClientSet& UI_ScrollBar::ClientSet ()
{
    return _clientSet;
}

inline bool& UI_ScrollBar::SmoothScroll ()
{
    return _smoothScroll;
}



#endif
