

#ifndef _scrolwin_h_ /* Mon Jan  1 20:22:03 1996 */
#define _scrolwin_h_


// A ScrollableWindow is a window that comes with two scroll bars at its
// right and bottom. These scroll bars are automatically repositioned to
// the right and bottom extremities of the window when the latter is
// resized. The scroll bars may be made visible or invisible under program
// control.


#include "ui/vobjcoll.h"
#include "ui/scrolbar.h"

class YACL_UI UI_ScrollableWindow: public UI_VObjCollection {

public:
    UI_ScrollableWindow (UI_VObjCollection* parent,
                         const UI_Rectangle& shape,
                         UI_ViewID id);
    // Constructor: create a ScrollableWindow as a child of {\tt parent},
    // with the given shape and view id.
    
    UI_ScrollBar& HorzScrollBar ();
    // Return a reference to this window's horizontal scroll bar.
    
    UI_ScrollBar& VertScrollBar ();
    // Return a reference to this window's vertical scroll bar.
    
    bool Enable ();
    // Allow view to capture events. This overrides the inherited method.

    bool Disable ();
    // Prevent view from capturing events.

    void MakeInvisible ();
    // This overrides the inherited method.
    
    void MakeVisible ();
    // This overrides the inherited method.

    virtual UI_WindowClass WindowClass () const;
    // [For YACL internal use only] return the platform-specific window
    // class for the visual element of this object.


    const char* ClassName() const { return "UI_ScrollableWindow";};



protected:
    
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    bool _ShapeRectChanged ();

#if defined(__X_MOTIF__)
    void _PrivateInitialize ();
    // [X-windows-specific, YACL internal use only] Override the inherited
    // method.
    
    virtual void _SetupStyle (void* arg, short& argn);
    // [X-windows-specific, YACL internal use only] Override the inherited
    // method. 

#endif
    

    UI_ScrollBar* _horizontalBar;
    UI_ScrollBar* _verticalBar;
    
#if defined(__OS2__)
    UI_ViewHandle _frameHandle;

public:
    UI_ViewHandle FrameHandle () const {return _frameHandle;};
    // [OS/2-specific, YACL internal use only] Return the frame handle.

#elif defined(__X_MOTIF__)
    UI_ViewHandle _scrolledWindow;
#endif
};

#endif /* _scrolwin_h_ */
