

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/shadorec.h"
#include "ui/dwgsurf.h"
#include "ui/lineseg.h"


UI_ShadowRectangle::UI_ShadowRectangle (long x, long y, long w, long h,
                                        Style style, short shadowThickness,
                                        bool border, const UI_Color& base)
: UI_Rectangle (x, y, w, h), _showBorder (border), _baseColor (base)
{
    _thickness   = shadowThickness;
    _shadowStyle = style;
}



UI_ShadowRectangle::UI_ShadowRectangle (const UI_Rectangle& r,
                                        Style style, short shadowThickness,
                                        bool border, const UI_Color& base)
: UI_Rectangle (r), _showBorder (border), _baseColor (base)
{
    _thickness   = shadowThickness;
    _shadowStyle = style;
}


UI_ShadowRectangle::UI_ShadowRectangle (const UI_ShadowRectangle& r)
: UI_Rectangle (r), _thickness (r._thickness),
  _shadowStyle (r._shadowStyle), _showBorder (r._showBorder),
  _baseColor (r._baseColor)
    
{
}


UI_Rectangle UI_ShadowRectangle::Interior () const
{
    long s = _thickness+1;
    return UI_Rectangle (_origin + UI_Vector (s, s),
                         _width - s, _height - s);
}



bool UI_ShadowRectangle::DrawOn (UI_DrawingSurface& sfc,
                                 const UI_Point& p) const
{
    sfc.SaveState ();
    UI_Pen& pen = sfc.Pen ();
    UI_Color mediumShade  = _baseColor;
    UI_Color lightShade   = mediumShade.LightShadow();
    UI_Color darkShade    = mediumShade.DarkShadow();

    short i;
    long w = Width();
    long h = Height();
    long x = Left();
    long y = Top();

    UI_Vector vec (p);
    // Draw the outer rectangle
    if (_thickness >= 1 && _showBorder) {
        pen.Color (UIColor_Black);
        sfc.DrawRectangle (UI_Rectangle (x, y, w, h) + vec, UID_Outline);
    }
    
    // Fill the interior of the rectangle:
    sfc.Brush().Color   (mediumShade);
    sfc.Brush().Pattern (UIBrush_Solid);
    sfc.DrawRectangle (UI_Rectangle (x + _thickness, y + _thickness,
                                     w - 2 * _thickness,
                                     h - 2 * _thickness)
                       + vec,
                       UID_Fill);
    if (_shadowStyle == Raised) {
        // Draw the top left shadow
        pen.Color (lightShade);
        for (i = 1; i <= _thickness; i++) {
            UI_Point p1 (x+i,     y+i);
            UI_Point p2 (x+w-i-1, y+i);
            UI_Point p3 (x+i,     y+h-i-1);
            sfc.DrawLine (p1 + vec, p2 + vec); // Horizontal
            sfc.DrawLine (p1 + vec, p3 + vec); // Vertical
        }

        // Draw the bottom shadow
        pen.Color (darkShade);
        for (i = 1; i <= _thickness; i++) {
            UI_Point p1 (x+i+1,   y+h-i-1);
            UI_Point p2 (x+w-i-1, y+h-i-1);
            UI_Point p3 (x+w-i-1, y+i+1);
            sfc.DrawLine (p1 + vec, p2 + vec);  // Horizontal
            sfc.DrawLine (p2 + vec, p3 + vec);  // Vertical
        }
    }
    else {
        pen.Color (darkShade);
        for (i = 1; i <= _thickness; i++) {
            UI_Point p1 (x+i,     y+i);
            UI_Point p2 (x+w-i-1, y+i);
            UI_Point p3 (x+i,     y+h-i-1);
            sfc.DrawLine (p1 + vec, p2 + vec); // Horizontal
            sfc.DrawLine (p1 + vec, p3 + vec); // Vertical
        }

        // Draw the bottom shadow
        pen.Color (lightShade);
        for (i = 1; i <= _thickness; i++) {
            UI_Point p1 (x+i+1,   y+h-i-1);
            UI_Point p2 (x+w-i-1, y+h-i-1);
            UI_Point p3 (x+w-i-1, y+i+1);
            sfc.DrawLine (p1 + vec, p2 + vec);  // Horizontal
            sfc.DrawLine (p2 + vec, p3 + vec);  // Vertical
        }
    }

    // Draw the little diagonals at the corners
    if (_thickness >= 3) {
        pen.Color (darkShade);
        UI_LineSegment l1 (UI_Point (x, y),
                           UI_Point (x + _thickness, y + _thickness));
        UI_LineSegment l2 (UI_Point (x + w - 1, y),
                           UI_Point (x + w - _thickness, y + _thickness));
        l1.DrawOn (sfc);
        l2.DrawOn (sfc);
        l1 = l1 + UI_Vector (w - 1 - _thickness, h - 1 - _thickness);
        l2 = l2 + UI_Vector (-(w - 1 - _thickness), h - 1 - _thickness);
        l1.DrawOn (sfc);
        l2.DrawOn (sfc);
        sfc.DrawRectangle (UI_Rectangle (x + _thickness, y + _thickness,
                                         w - 2*_thickness,
                                         h - 2*_thickness));
    }
    sfc.RestoreState();
    return TRUE;
}

