
/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#include "ui/shadotrg.h"
#include "ui/dwgsurf.h"
#include "ui/color.h"


UI_ShadowedTriangle::UI_ShadowedTriangle
    (const UI_Rectangle& shape, Direction d, UI_ReliefStyle r, const
     UI_Color& clr)
: _shape (shape), _dir (d), _relief (r), _baseColor (clr)
{
}


UI_Rectangle UI_ShadowedTriangle::BoundingRectangle () const
{
    return _shape;
}



bool UI_ShadowedTriangle::DrawOn (UI_DrawingSurface& sfc, const UI_Point& p)
    const
{
    sfc.SaveState();
    UI_Color topColor, bottomColor;
    if (_relief == UIRelief_Raised) {
        topColor    = _baseColor.LightShadow();
        bottomColor = _baseColor.DarkShadow();
    }
    else {
        topColor    = _baseColor.DarkShadow();
        bottomColor = _baseColor.LightShadow();
    }
    long x = _shape.Left(), y = _shape.Top(), w = _shape.Width(), 
        h = _shape.Height();
    long x1, y1, x2, y2, x3, y3; // Points in clockwise order, beginning at
                                 // left end.
    switch (_dir) {
    case North:
        x1 = x,           y1 = y + h - 1;
        x2 = x + w/2,     y2 = y;
        x3 = x + w - 1,   y3 = y + h - 1;
        break;

    case East:
        x1 = x,           y1 = y + h - 1;
        x2 = x,           y2 = y;
        x3 = x + w - 1,   y3 = y + h/2;
        break;

    case South:
        x1 = x + w/2,     y1 = y + h - 1;
        x2 = x,           y2 = y;
        x3 = x + w - 1,   y3 = y;
        break;

    case West:
        x1 = x,           y1 = y + h/2;
        x2 = x + w - 1,   y2 = y;
        x3 = x + w - 1,   y3 = y + h - 1;
        break;
    };

    UI_Point polygon[3];
    x1 += p.XCoord(), y1 += p.YCoord();
    polygon[0] = UI_Point (x1, y1);
    polygon[1] = UI_Point (x2, y2);
    polygon[2] = UI_Point (x3, y3);
    sfc.Brush().Color (_baseColor);
    sfc.DrawPolygon (polygon, 3, UID_Fill);

    UI_Pen& pen = sfc.Pen();
    if (_dir == West || _dir == North) {
        pen.Color (topColor);
        sfc.DrawLine (UI_Point (x1, y1), UI_Point (x2, y2));
        pen.Color (bottomColor);
        sfc.DrawLine (UI_Point (x2, y2), UI_Point (x3, y3));
        sfc.DrawLine (UI_Point (x1, y1), UI_Point (x3, y3));
    }
    else {
        pen.Color (topColor);
        sfc.DrawLine (UI_Point (x1, y1), UI_Point (x2, y2));
        sfc.DrawLine (UI_Point (x2, y2), UI_Point (x3, y3));
        pen.Color (bottomColor);
        sfc.DrawLine (UI_Point (x1, y1), UI_Point (x3, y3));
    }

    sfc.RestoreState ();
    return TRUE;
}

    
void UI_ShadowedTriangle::operator+= (const UI_Vector& vec)
{
    if (PrepareToChange()) {
        _shape += vec;
        Notify();
    }
}
