


#ifndef _shadotrg_h_ /* Fri May  3 23:06:08 1996 */
#define _shadotrg_h_



// A ShadowedTriangle is a triangle drawn with a shadow around it to make it
// look raised or recessed. It uses a 1-pixel border for the shadow. A
// ShadowedTriangle can point North, South, East or West.



#include "ui/rectangl.h"
#include "ui/color.h"

class  YACL_UI UI_ShadowedTriangle: public UI_GraphicObject {

public:
    enum Direction {North, South, East, West};

    UI_ShadowedTriangle (const UI_Rectangle& shape, Direction d,
                         UI_ReliefStyle r,
                         const UI_Color& baseColor = UIColor_MediumGray);
    // Create a ShadowedTriangle with the given shape, direction and relief
    // style. The base of the triangle is the rectangle dimension opposite
    // the pointed direction; for example, a North triangle uses the
    // rectangle's bottom as base.

    UI_Rectangle BoundingRectangle () const;
    // Return the bounding rectangle for this ShadowedTriangle.

    bool DrawOn  (UI_DrawingSurface& sfc,
                  const UI_Point& p = UI_Point (0, 0)) const;
    // Draw this object on the surface sfc at the given point.

    void operator+= (const UI_Vector& p);
    // Translate this triangle by the given vector.

protected:
    UI_Rectangle   _shape;
    Direction      _dir;
    UI_ReliefStyle _relief;
    UI_Color       _baseColor;
};

#endif /* _shadotrg_h_ */
