




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#if defined(__GNUC__)
#pragma implementation
#endif

                 
#include "base/binding.h"
#include "ui/simple.h"
#include "ui/cntroler.h"
#include "ui/vobjcoll.h"
#include "ui/font.h"

#if (defined(__MS_WINDOWS__) || defined(__MS_WIN32__)) && defined(USE_CTL3D)
#    include <ctl3d.h>
#endif

#if defined (__X_MOTIF__)  || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    if defined(__X_MOTIF__)
#        include <X11/Intrinsic.h>
#        include <X11/StringDefs.h>
#        include <X11/Shell.h>
#        include <Xm/Xm.h>
#    endif
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_SimpleVObject>;
#endif


typedef CL_Binding0<UI_SimpleVObject> SimpleBind;


#if defined(__OS2__) && defined(__IBMCPP__)
inline MRESULT EXPENTRY CallBackSubclassProc( HWND hWnd, ULONG msg,
                                              MPARAM p1, MPARAM p2)
{
    return UI_SimpleVObject::SubclassProc( hWnd, msg, p1, p2);
}
#endif

UI_SimpleVObject :: UI_SimpleVObject
    (UI_VisualObject* p, const UI_Rectangle& shape, UI_ViewID id, long style)
: UI_VisualObject (p,  shape, id, style)
{
   _ownModel = TRUE;
   _model = NULL;
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_SimpleVObject :: UI_SimpleVObject
    ( UI_VObjCollection* p, UI_ViewID id, UI_ViewHandle h)
: UI_VisualObject (p, id, h)
{
   _ownModel = TRUE;
   _model = NULL;
}
#endif


UI_SimpleVObject :: UI_SimpleVObject
    (UI_VisualObject* p, CL_Object* md, UI_ViewID id,
      const UI_Rectangle& r, long style)
: UI_VisualObject (p, r, id, style)
{
    if (!_parent)
        CL_Error::Warning ("SimpleVObject constructor: class '%s' id %d:"
                           " NULL parent!", ClassName(), id);
   _ownModel = FALSE;
   _model = md;
}



UI_SimpleVObject :: ~UI_SimpleVObject()
{
    if (_ownModel && _model)
        delete _model;
}


bool UI_SimpleVObject::_ModelChanged ()
{
    Invalidate ();
    return TRUE;
}


bool UI_SimpleVObject::MakeVisualElement ()
{
    bool b = UI_VisualObject::MakeVisualElement ();
#if (defined(__MS_WINDOWS__) || defined(__MS_WIN32__)) && defined(USE_CTL3D)
    if (Has3DLook ())
        Ctl3dSubclassCtl (_handle);
#endif
    return b;
}


void UI_SimpleVObject :: _PrivateInitialize()
{
    UI_VisualObject :: _PrivateInitialize ( );
#if defined(__OS2__)
    // Mouse moves are not queued under OS/2. We need to be able to set
    // cursors for simple objects also, and this can only be done on each
    // mouse move. Therefore we subclass. Note that if we subclass in
    // MakeVisualElement, we get into trouble: a message sent to the control
    // before MakeVisualElement finishes execution will fail, because the
    // subclassing procedure's call to the Controller's op[] will fail. This
    // is why the subclassing is done here rather than in MakeVisualElement.
    UI_WindowClass wClass = WindowClass();
    if (wClass != NULL && wClass != WC_COMBOBOX)
        // Don't subclass menu items or combo boxes
        _Subclass ();
#endif
    if (_model) {
        SimpleBind b (this, &UI_SimpleVObject::_ModelChanged);
        _model->AddDependent (b);
    }
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h && _handle && !_parent->CreatedViaResource())
        SendMessage (_handle, WM_SETFONT, (WPARAM) h, TRUE);
#endif
//     if (_font)
//         _SetPlatformFont (ViewHandle());
}




bool UI_SimpleVObject :: DestroyVisualElement ()
{
    return UI_VisualObject::DestroyVisualElement();
}





UI_WindowClass UI_SimpleVObject::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLSimpleClassName;
#elif defined(__X_MOTIF__)
    return shellWidgetClass;
#endif
}


bool UI_SimpleVObject :: SetStyleParam ( )
{
    // This is used only for resource-based construction
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_handle)
        return TRUE;
    RECT rec;

#if defined(__MS_WIN32__)
    _id = GetWindowLong    (_handle,GWL_ID);  
#else
    _id = GetWindowWord    (_handle,GWW_ID);
#endif
    _style = GetWindowLong (_handle,GWL_STYLE); 
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    _isTabStop = _style & WS_TABSTOP ? TRUE : FALSE;
    GetWindowRect (_handle, &rec);
    POINT array[2];
    array[0].x = rec.left;
    array[0].y = rec.top;
    array[1].x = rec.right;
    array[1].y = rec.bottom;
    MapWindowPoints (NULL, _parent->ViewHandle(), array, 2);
    UI_Point org(array[0].x, array[0].y);
    UI_Rectangle shp(org, array[1].x-array[0].x, array[1].y-array[0].y);
    _SetShapeRectangle (shp);

#else
    NotImplemented ("SetStyleParam");
#endif
    return TRUE;
}




#if defined(__OS2__)
MRESULT
#if !defined(__IBMCPP__)
EXPENTRY
#endif
UI_SimpleVObject::SubclassProc (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    UI_SimpleVObject* obj = (UI_SimpleVObject*) (*_Controller)[hWnd];
    if (obj) {
        MRESULT retVal = (*(obj->_oldProc)) (hWnd, msg, p1, p2);
        if (msg == WM_MOUSEMOVE)
            _Controller->SetCurrentCursor (obj->Cursor());
        obj->WindowProcHook (hWnd, msg, p1, p2);
        return retVal;
    }
    return WinDefWindowProc (hWnd, msg, p1, p2);
}


void UI_SimpleVObject::_Subclass ()
{
    if (!_handle)
        return;
#if defined(__IBMCPP__)
    _oldProc = WinSubclassWindow (_handle, CallBackSubclassProc);
#else
    _oldProc = WinSubclassWindow (_handle, UI_SimpleVObject::SubclassProc);
#endif
}



void UI_SimpleVObject::WindowProcHook (HWND, ULONG, MPARAM,
                                       MPARAM)
{
    // Do nothing. Subclasses might use this hook.
}

#endif


#if defined(__X_MOTIF__)
bool UI_SimpleVObject::_ShapeRectChanged ()
{
    UI_VisualObject::_ShapeRectChanged ();
    return TRUE;
}

#endif
