

#ifndef _stddlg_h_ /* Tue Jan  4 14:59:57 1994 */
#define _stddlg_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// This header file defines functions for ``standard'' dialogs  for yes/no
// and informational message boxes and for file selection.
//
// Caveat: Under Motif, the parent of a StandardDialog *must* be a non-null,
// currently-displayed window. Otherwise you might not get the
// StandardDialog displayed properly.

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/visualob.h"


// ---------------- Standard question or info dialog -------------------


// Dialog styles:
enum UI_StandardDialogStyle {
    UIS_Ok, UIS_OkCancel, UIS_YesNo, UIS_YesNoCancel
};


// Dialog icon styles:
enum UI_StandardDialogIconStyle {
    UIS_Information, UIS_Warning, UIS_Error, UIS_Question
};

UI_ViewID YACL_UIFUNC UI_StandardDialog
    (const char* message, const char* box_title = "",
     UI_CompositeVObject* parent = NULL,
     UI_StandardDialogStyle style = UIS_Ok,
     UI_StandardDialogIconStyle icon = UIS_Information);
// Show the specified kind of dialog, and return the id of the button
// clicked on.



// ---------------------- Open file dialog ----------------------------

#if defined(__UNIX__)
#define UI_FILESELECT_DEFAULT_TYPE_MASK "*"
#else
#define UI_FILESELECT_DEFAULT_TYPE_MASK "*.*"
#endif


CL_String YACL_UIFUNC UI_FileSelectDialog
    (UI_VisualObject* parent, const char* initialDir = "",
     const char* boxTitle = "Open file",
     const char* typeMask =
     UI_FILESELECT_DEFAULT_TYPE_MASK);
// Show the platform's file-open dialog, and return the chosen file name.
// Return the null string if canceled. Under Windows, this function uses
// the Open File dialog if typeMask is non-null, and the the Save As dialog
// if typeMask is null or equals "" (the null string).


class YACL_UI UI_FontDesc;

bool UI_FontDialog (UI_CompositeVObject* parent, UI_FontDesc& desc);
// Show the platform's standard font selection dialog as a child of {\tt
// parent} and return the user-selected font in the second parameter. Return
// TRUE as function value if the user selected {\tt ok}, and FALSE if either
// {\tt cancel} was clicked or the dialog was closed via the system menu.
//
// This function is currently only implemented under Windows, Win32 and
// OS/2. It is not yet implemented under Motif.



// UI_ViewID YACL_UIFUNC UI_SimpleDialog (const char* message,
//                                          const char* box_title = "",
//                                          UI_CompositeVObject* parent = NULL,
//                                          UI_StandardDialogStyle style = UIS_Ok,
//                                          UI_StandardDialogIconStyle icon =
//                                          UIS_Information);
// Retained temporarily, for backward compatibility.


#endif /* _stddlg_h_ */
