




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/binding.h"
#include "ui/strseq.h"
#include "ui/strview.h"

#if defined (__GNUC__)
template class CL_Binding0<UI_StringSequence>;
template class CL_Binding2<CL_String, UI_StringSequence>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_StringSequence>;
template CL_Binding2<CL_String, UI_StringSequence>;
#endif


typedef CL_Binding2<CL_String, UI_StringSequence> SeqBind2;
typedef CL_Binding0<UI_StringSequence> SeqBind0;


UI_StringSequence::UI_StringSequence ()
{
    SeqBind0 bind (this, &UI_StringSequence::_ReassignCodes);
    AddDependent  (bind);
}


UI_StringSequence::UI_StringSequence (const char* data[], long count)
: CL_StringSequence (data, count)
{
    SeqBind0 bind (this, &UI_StringSequence::_ReassignCodes);
    AddDependent  (bind);
    _ReassignCodes ();
}


bool UI_StringSequence::_ReassignCodes ()
{
    // Called when the sequence has a structural change
    long n = Size();
    for (long i = 0; i < n; i++) {
        SeqBind2 b (this, &UI_StringSequence::Update, i);
        (*this)[i].RemoveDependent (b); // This ignores the code in the
                                        // binding, so it's ok to remove and
                                        // add back
        (*this)[i].AddDependent (b);
    }
    return TRUE;
}


bool UI_StringSequence::Update (CL_String&, long index)
{
    // Called when one of the contained strings changes
    CL_ObjectSetIterator itr (_clientSet);
    while (itr.More())
        ((UI_StringView*) itr.Next())->ItemChanged (index);
    return TRUE;
}



void UI_StringSequence::AddClient (UI_StringView* v)
{
    _clientSet.Add(v);
}

void UI_StringSequence::RemoveClient (UI_StringView* v)
{
    _clientSet.Remove (v);
}





