





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/Frame.h>
#    include <Xm/BulletinB.h>
#    include <Xm/List.h>
#elif defined(__X_YACL__)
#    include <iostream.h> // DEBUG
#    include "ui/support/x_yacl/window.h"
#    include "ui/scrolbar.h"
#    include "ui/shadorec.h"
#    include "ui/dsinmem.h"
#    define SCROLL_BAR_THICKNESS 16
#endif

#include "ui/strview.h"
#include "ui/cntroler.h"
#include "ui/event.h"
#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/dsplsurf.h"

#include "base/intset.h"



typedef CL_Binding0      <UI_StringView> StrViewBind;
typedef UI_EventBinding1 <UI_StringView> StrViewBind1;

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#define LISTBOX_STYLE LBS_NOTIFY | LBS_USETABSTOPS | WS_CHILD | WS_VISIBLE \
        | WS_BORDER | WS_HSCROLL | WS_VSCROLL | WS_TABSTOP
#elif defined(__OS2__)
#define LISTBOX_STYLE LS_HORZSCROLL | WS_VISIBLE
#endif


#if defined(__GNUC__)
template class CL_Binding0<UI_StringView>;
template class UI_EventBinding1 <UI_StringView>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_StringView>;
#endif



UI_StringView::UI_StringView
    (UI_VisualObject* p, UI_StringSequence* model,
     const UI_Rectangle& shape, bool mult, UI_ViewID id, long s)
: UI_SimpleVObject (p, shape, id, s)
{   
    _multiple = mult;
    _model    = model;
    _ownModel = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_style == 0xffffffffL)
        _style = LISTBOX_STYLE;
    if (_multiple)
        _style |= LBS_MULTIPLESEL;
#elif defined(__OS2__)
    _style = LISTBOX_STYLE;
    if (_multiple)
        _style |= LS_MULTIPLESEL | LS_EXTENDEDSEL;
#elif defined(__X_MOTIF__)
    _list =  NULL;
#elif defined(__X_YACL__)
    long xh = 0, yh = _shape.Height() - SCROLL_BAR_THICKNESS,
        wh = shape.Width() - SCROLL_BAR_THICKNESS, hh = SCROLL_BAR_THICKNESS;
    long xv = _shape.Width() - SCROLL_BAR_THICKNESS, yv = 0,
        wv = SCROLL_BAR_THICKNESS, hv = shape.Height();
    _hBar = new UI_HScrollBar (this, UI_Rectangle (xh, yh, wh, hh), 101);
    _vBar = new UI_VScrollBar (this, UI_Rectangle (xv, yv, wv, hv), 102);
    _visibleCount = 0;
    _topElement = 0;
#endif
}



UI_StringView::UI_StringView
    (UI_VisualObject* p, const UI_Rectangle& shape,
     bool mult, UI_ViewID id, long s
    )
: UI_SimpleVObject (p, shape, id, s)
{  
    _model = new UI_StringSequence; 
    _multiple = mult;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if ( _style == 0xffffffffL )
        _style = LISTBOX_STYLE;
    if ( _multiple )
        _style |= LBS_MULTIPLESEL;
#elif defined(__OS2__)
    _style = LISTBOX_STYLE;
    if (_multiple)
        _style |= LS_MULTIPLESEL | LS_EXTENDEDSEL;
#elif defined(__X_MOTIF__)
    _list = NULL;
#elif defined(__X_YACL__)
    long xh = 0, yh = _shape.Height() - SCROLL_BAR_THICKNESS,
        wh = shape.Width() - SCROLL_BAR_THICKNESS, hh = SCROLL_BAR_THICKNESS;
    long xv = _shape.Width() - SCROLL_BAR_THICKNESS, yv = 0,
        wv = SCROLL_BAR_THICKNESS, hv = shape.Height();
    _hBar = new UI_HScrollBar (this, UI_Rectangle (xh, yh, wh, hh), 101);
    _vBar = new UI_VScrollBar (this, UI_Rectangle (xv, yv, wv, hv), 102);
    StrViewBind1 scrollBind (this, &UI_StringView::_VertScroll);
    _vBar->ClientSet().Add (scrollBind);
    _vBar->SmoothScroll() = TRUE;
    _visibleCount = 0;
    _topElement = 0;
#endif
}


void UI_StringView::ScrollTo (long index)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle && index >= 0)
        SendMessage (_handle, LB_SETTOPINDEX, (UINT) index, 0);
#elif defined(__OS2__)
    if (_handle && index >= 0)
        WinSendMsg (_handle, LM_SETTOPINDEX, (MPARAM) index, 0);
#elif defined(__X_MOTIF__)
    if (_list && index >= 0)
        XmListSetPos (_list, index-1);
#elif defined(__X_YACL__)
    if (_window && index >= 0) {
        CL_Interval& vBarModel = (CL_Interval&) (_vBar->Model());
        long l = vBarModel.Length();
        _vBar->Model() = CL_Interval (index, index+l-1);
        long n = ((UI_StringSequence*) _model)->Size();
        _topElement = maxl (0, minl (index, n  - _visibleCount));
        _Redraw();
    }
#endif
}

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_StringView::UI_StringView
    (UI_CompositeVObject* p, UI_ViewID id, UI_ViewHandle h)
: UI_SimpleVObject (p, id, h)
{
    _model = new UI_StringSequence;
    ((UI_StringSequence*) _model)->AddClient (this);
}
#endif



UI_StringView::~UI_StringView ()
{
    ((UI_StringSequence*) _model)->RemoveClient (this);
#if defined(__X_MOTIF__)
    // destruction was taken care of by ~VisualObject()
    _list = NULL;
#endif
}


long UI_StringView::TopIndex () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return _handle ? SendMessage (_handle, LB_GETTOPINDEX, 0, 0) : -1;
#elif defined(__OS2__)
    return _handle ? (long) WinSendMsg (_handle, LM_QUERYTOPINDEX, 0, 0) : -1;
#elif defined(__X_MOTIF__)
    int pos;
    XtVaGetValues (_list, XmNtopItemPosition, &pos, NULL);
    return pos-1;
#elif defined(__X_YACL__)
    return _topElement;
#endif
}


short UI_StringView::VisibleCount () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_handle)
        return 0;
    long h = SendMessage (_handle, LB_GETITEMHEIGHT, 0, 0);
    return h > 0 ? _shape.Height() / h : 0;
#elif defined(__OS2__)
    return _itemCount;
#elif defined(__X_MOTIF__)
    int size;
    XtVaGetValues (_list, XmNvisibleItemCount, &size, NULL);
    return size;
#elif defined(__X_YACL__)
    return _visibleCount;
#endif
}


#if defined(__OS2__)
bool UI_StringView::_ShapeRectChanged ()
{
    bool b = UI_SimpleVObject::_ShapeRectChanged ();
    _UpdateItemCount ();
    return b;
}

void UI_StringView::_UpdateItemCount ()
{
    // This is a ridiculous hack, but it seems to work.
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    short h = sfc.Font().Height();
    DestroyDisplaySurface();
    short scrollBarWidth = WinQuerySysValue (HWND_DESKTOP, SV_CXVSCROLL);
    _itemCount = (_shape.Height() - scrollBarWidth) / maxl (1, h);
}

#endif



#if defined(__X_MOTIF__)
static void _SetShape (Widget xWidget, const UI_Rectangle& shape)
{

    Arg arg [4];
    short argn = 0;
    short x = shape.Left   ();
    short y = shape.Top    ();
    short w = shape.Width  ();
    short h = shape.Height ();

    if (xWidget) {
        XtSetArg (arg [ argn ], XtNx,     x); argn++;
        XtSetArg (arg [ argn ], XtNy,     y); argn++;
        XtSetArg (arg [ argn ], XtNheight,h); argn++;
        XtSetArg (arg [ argn ], XtNwidth, w); argn++;
        XtSetValues (xWidget, arg, argn);
    }

}
#endif

void UI_StringView::MakeVisible ()
{
    UI_SimpleVObject::MakeVisible ();

#if defined(__X_MOTIF__)
    // Somehow the dimensions od a scrolled list are not correct if
    // set before XtManageChild(). So we set it every time one calls
    // MakeVisible().
    if (_xwidget) {
        XtManageChild (_xwidget);
        XtManageChild (_list);
        _SetShape (_xwidget, _shape);
        XtVaSetValues (_xwidget, XmNmarginWidth,  0,
                       XmNmarginHeight,  0, NULL);
    }
#endif
}

void UI_StringView::MakeInvisible ()
{
    UI_SimpleVObject::MakeInvisible ();
#if defined(__X_MOTIF__)
    if (_xwidget)
        XtUnmanageChild (_xwidget);
#endif
}


#if defined(__X_MOTIF__)
void UI_StringView::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add more resource specs:
    XtSetArg (arg [ argn ], XmNlistSizePolicy, XmCONSTANT);     argn++;
    XtSetArg (arg [ argn ], XmNselectionPolicy,
              _multiple ? XmMULTIPLE_SELECT : XmSINGLE_SELECT); argn++;
    // -------------------  ^^^^^^^^ ---------------------
    // If I use EXTENDED_SELECT, then the setting of selection under program
    // control doesn't seem to work right. If The MultiSel box's Selection()
    // is assigned to, only the highest-indexed one of the strings gets
    // highlighted, even though the selection set contains several indices.
}
#endif




bool UI_StringView::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return UI_SimpleVObject::MakeVisualElement();
#elif defined(__X_YACL__)
    _visualElement = new YVE_Window (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
#elif defined(__X_MOTIF__)

    // This code is copied from that of SimpleVObject, except that we use
    // XmCreateScrolledList instead of XtCreateWidget, because the scroll
    // bar does not seem to be displayed otherwise.

    // The other problem: all sizing stuff must be done on the surrounding
    // XmScrolledWindow which is implicit created by XmCreateScrolledList
    // So we set the _xwidget to the ScrolledWindow and keep the handle
    // for the list itself in _list
    
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    Arg arg [20];
    short argn = 0;

    CL_String instance_name = InstanceName();
    const char* inst_name   = instance_name.AsPtr();

    _SetupStyle (arg, argn);

    _list = XmCreateScrolledList (pw, (char*) inst_name, arg, argn);
    _xwidget = XtParent(_list);

    XtManageChild (_xwidget);
    XtManageChild (_list);
    XtUnmanageChild (_xwidget);

    return TRUE;
#endif
}




void UI_StringView::ItemChanged (long i)
{
    CL_String s = (*(UI_StringSequence*)_model)[i];
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_handle, WM_SETREDRAW,  FALSE, 0L);
    SendMessage (_handle, LB_DELETESTRING, i, 0L);
    SendMessage (_handle, LB_INSERTSTRING, i, (long) s.AsPtr());
    SendMessage (_handle, WM_SETREDRAW, TRUE, 0L);
#elif defined(__OS2__)
    if (_handle) {
        WinDeleteLboxItem (_handle, i);
        WinInsertLboxItem (_handle, i, s.AsPtr());
    }
#elif defined(__X_MOTIF__)
    XmListDeletePos (_list, i+1);    
    XmString xs;
    char* item = (char*) s.AsPtr ();
    xs = XmStringCreate (item, XmSTRING_DEFAULT_CHARSET);
    XmListAddItem (_list, xs, i+1);
    XmStringFree (xs);
#endif
    _SelectionChanged(); // Force an update of highlighted strings
}


bool UI_StringView::_ModelChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        SendMessage (_handle, LB_RESETCONTENT, 0,     0);
        _AddModelStrings ();
        _UpdateSelection ();
    }
#elif defined(__OS2__)
    if (_handle) {
        WinSendMsg (_handle, LM_DELETEALL, 0, 0);
        _AddModelStrings ();
        _UpdateSelection ();
    }
#elif defined(__X_MOTIF__)
    if (_list) {
        XmListDeleteAllItems (_list);
        _AddModelStrings ();
        _UpdateSelection ();
    }
#elif defined(__X_YACL__)
    if (_window) {
        _topElement = 0;
        _SetupScrollBar ();
        _EmptySelection ();
        _Redraw ();
    }
#endif
    return TRUE;
}




void UI_StringView::_AddModelStrings ()
{
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    long n = theModel.Size();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (n) {
        SendMessage (_handle, WM_SETREDRAW,    FALSE, 0);
        SendMessage (_handle, LB_RESETCONTENT, 0,     0);
        for (long i = 0; i < n; i++) {
            SendMessage (_handle, LB_ADDSTRING, 0,
                         (long) theModel[i].AsPtr());
        }
        SendMessage (_handle, WM_SETREDRAW, TRUE, 0L);
    }
#elif defined(__OS2__)
    WinEnableWindowUpdate (_handle, FALSE);
    WinSendMsg (_handle, LM_DELETEALL, 0, 0);
    for (long i = 0; i < n; i++)
        WinInsertLboxItem (_handle, LIT_END, theModel[i].AsPtr());
    WinEnableWindowUpdate (_handle, TRUE);
    if (IsVisible())
        WinShowWindow (_handle, TRUE);
#elif defined(__X_MOTIF__)
    if (n) {
        for (long i = 0; i < n; i++) {
            XmString  xs = XmStringCreate ((char*) theModel[i].AsPtr(),
                                           XmSTRING_DEFAULT_CHARSET); 
            XmListAddItem (_list, xs, 0);
            XmStringFree (xs);
        }
    }

    // Hmmm... somehow the list resizes after the model changes. Maybe this
    // is due to the resource XmNvisibleItemCount ?. But we have to work
    // around it anyway since we want the size to be pixel based not
    // row based. So:
    _SetShape (_xwidget, _shape);
#endif
}


void UI_StringView::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    theModel.AddClient (this);
    _AddModelStrings ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_visible)
        ShowWindow (_handle, SW_HIDE); // Need this, because the above
                                       // AddModelStrings may have made the
                                       // box visible
    _FontChanged();
#elif defined(__OS2__)
    if (!_visible)
        WinShowWindow (_handle, FALSE);// Need this, because the above
                                       // AddModelStrings may have made the
                                       // box visible
    _FontChanged();
#elif defined(__X_MOTIF__)
    XtVaSetValues (_list, XmNmarginWidth, 0, XmNmarginHeight, 0, NULL);
    XtAddCallback (_list, XmNbrowseSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_list, XmNsingleSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_list, XmNextendedSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_list, XmNmultipleSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_list, XmNdefaultActionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    if (_visible) {
        // Just call MakeVisible() here instead of XtManageChild()
        MakeVisible();
    }

    if (!_enabled) {
        XtSetSensitive (_list, FALSE);
    }
    _FontChanged();
#elif defined(__X_YACL__)
    _FontChanged();
    _topElement = 0;
    _SetupScrollBar ();
#endif

}



UI_WindowClass UI_StringView::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "listbox";
#elif defined(__OS2__)
    return WC_LISTBOX;
#elif defined(__X_MOTIF__)
    return xmListWidgetClass;
#endif
}


#if defined (__X_MOTIF__)

void UI_StringView::Callback (Widget , void* client, void* call)
{
    UI_StringView* sv = (UI_StringView *) client;
    XmListCallbackStruct* cb = (XmListCallbackStruct*) call;
    UI_Event* e;
    
    switch (cb->reason) {

    case XmCR_SINGLE_SELECT:
    case XmCR_BROWSE_SELECT:
    case XmCR_MULTIPLE_SELECT:
    case XmCR_EXTENDED_SELECT:
        e = new UI_Event (Event_Select, sv, sv);
        if (e)
            _Controller->AddEvent (e);
        break;

    case XmCR_DEFAULT_ACTION:
        e = new UI_Event (Event_LButtonDblClk, sv, sv);
        if (e) {
            e->SetPosition (UI_Point (cb->event->xbutton.x,
                                      cb->event->xbutton.y));
            _Controller->AddEvent (e);
        }
        break;

    default:
        break;
    }
        
}

#endif

bool UI_StringView::_FontChanged ()
{
#if defined(__OS2__)
    _UpdateItemCount ();
    return TRUE;
#elif defined(__X_MOTIF__)
    UI_ViewHandle xwidget = _xwidget;
    _xwidget = _list;
    bool b = UI_SimpleVObject::_FontChanged ();
    _xwidget = xwidget;

    // Motif has the "feature" that when the font of a StringEditor is
    // changed, it mucks with its shape. So:
    if (_xwidget) {
        long x = _shape.Width(), y = _shape.Height();
        XtVaSetValues (_xwidget, XmNwidth, x, XmNheight, y,  NULL);
    }
    return b;
#elif defined(__X_YACL__)
    _charHeight = _font->Height();
#else
    return TRUE;
#endif
}







#if defined(__X_YACL__)
void UI_StringView::_DrawClientArea (UI_DrawingSurface& sfc,
                                     const UI_Rectangle& area)
{
    if (_charHeight <= 1)  // Something wrong
        return;

    UI_StringSequence& modelSeq = *(UI_StringSequence*) _model;
    // Determine the box in which the strings will be drawn
    UI_Rectangle box = area;
    long boxHeight = box.Height();
    long modelSize  = modelSeq.Size();
    sfc.Pen().Color(UIColor_Black);
    // Draw the strings
    short count = minl (_topElement + _visibleCount, modelSize);
    short yOffset = area.Top() + 1;
    short textWidth = box.Width()-4; // text rectangle is narrower than box
    for (long i = _topElement; i < count
         && yOffset + _charHeight <= boxHeight; i++, yOffset += _charHeight)
        sfc.WriteString (modelSeq(i), _ItemRectangle (i));
    _HighlightSelection (sfc);
}

bool UI_StringView::HandleEvent (UI_Event* e)
{
    if (!e)
        return FALSE;
    UI_EventType typ = e->Type();
    if (typ == Event_Paint) {
        _Redraw ();
    }
    else if (typ == Event_LButtonPress) {
        if (_charHeight <= 1)
            return FALSE;  // Safety check
        short index = e->Position().YCoord() / _charHeight;
        if (index >= _visibleCount)
            return FALSE;
        UI_StringSequence& modelSeq = *(UI_StringSequence*) _model;
        long newSelection = _topElement + index;
        if (newSelection >= modelSeq.Size())
            return FALSE;
        _DoSelect (newSelection);
        UI_Event evt (Event_Select, this, this);
        _Controller->DispatchEvent (&evt);
    }
    return ProcessEvent (e);
}

bool UI_StringView::_VertScroll (UI_Event& e)
{
    if (e.Type() != Event_FinishScroll) {
        UI_StringSequence& modelSeq = *(UI_StringSequence*) _model;
        _topElement = _visibleCount >= modelSeq.Size() ? 0
            : ((CL_Interval&) _vBar->Model ()).Low ();
        _Redraw();
    }
    
}

bool UI_StringView::_ShapeRectChanged ()
{
    long xh = 0, yh = _shape.Height() - SCROLL_BAR_THICKNESS,
        wh = _shape.Width() - SCROLL_BAR_THICKNESS, hh = SCROLL_BAR_THICKNESS;
    long xv = _shape.Width() - SCROLL_BAR_THICKNESS, yv = 0,
        wv = SCROLL_BAR_THICKNESS, hv = _shape.Height();
    _hBar->Shape() = UI_Rectangle (xh, yh, wh, hh);
    _vBar->Shape() = UI_Rectangle (xv, yv, wv, hv);
    return TRUE;
}

void UI_StringView::_SetupScrollBar ()
{
    UI_StringSequence& modelSeq = *(UI_StringSequence*) _model;
    long size = modelSeq.Size();
    short ht = _shape.Height();
    short n  =  ht / maxl (_charHeight, 1);
    if (size <= n) {
        _visibleCount = n;
        _hBar->SetVisibility (FALSE);
    }
    else {
        _visibleCount = (ht - SCROLL_BAR_THICKNESS) / maxl (_charHeight, 1);
        _hBar->SetVisibility (TRUE);
    }
    _vBar->SetVisibility (_visibleCount < size ? TRUE : FALSE);
    _vBar->PageAmount() = _visibleCount-1;
    _vBar->Range () = CL_Interval
        (0, maxl (_visibleCount,  size) - 1);
    CL_Interval& scrollInterval = (CL_Interval&) _vBar->Model();
    long low = _topElement; // maxl (0, minl (scrollInterval.Low(), size-1));
    scrollInterval = CL_Interval (low, low + _visibleCount - 1);
}



void UI_StringView::_Redraw ()
{
    short w = _shape.Width();
    if (_vBar->IsVisible())
        w -= SCROLL_BAR_THICKNESS;
    short h = _shape.Height();
    if (_hBar->IsVisible())
        h -= SCROLL_BAR_THICKNESS;
    UI_ShadowRectangle area (0, 0, w, h, UI_ShadowRectangle::Recessed, 2,
                             FALSE, _bgColor);
    UI_DisplaySurface& sfc = CreateDisplaySurface();
    area.DrawOn (sfc);
    _DrawClientArea (sfc, area.Interior());
    DestroyDisplaySurface();
}

#endif




// ----------------- Single selection StringViews ----------------------

UI_StringViewSingleSel::UI_StringViewSingleSel (UI_VisualObject* parent,  
                        const UI_Rectangle& shape,
                        UI_ViewID id)
: UI_StringView (parent, shape, FALSE, id), _selection (-1)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind); // Notification code is not used
}



UI_StringViewSingleSel::UI_StringViewSingleSel
    (UI_VisualObject* parent, UI_StringSequence* model,
     const UI_Rectangle& shape, UI_ViewID id)
: UI_StringView (parent, model, shape, FALSE, id), _selection (-1)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind);
}




#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_StringViewSingleSel::UI_StringViewSingleSel
    (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h)
: UI_StringView (parent, id, h), _selection (-1)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind);
}
    
#endif



bool UI_StringViewSingleSel::Select ()
{
    // Called in response to Event_Select generated when the user changes a
    // selection
    _UpdateSelection ();
    return FALSE; // So that the parent gets a chance to handle this event
}





void UI_StringViewSingleSel::_UpdateSelection ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    long pos = 0;
    pos = SendMessage (_handle, LB_GETCURSEL, 0, 0);
    if (pos == LB_ERR)
        pos = -1;
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection = pos;
    _selection.AddDependent (bind);
#elif defined(__OS2__)
    long pos = 0;
    pos = (long) WinSendMsg (_handle, LM_QUERYSELECTION, (MPARAM) -1, 0);
    if (pos == LIT_NONE)
        pos = -1;
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection = pos;
    _selection.AddDependent (bind);
#elif defined(__X_MOTIF__)
    long pos = 0;
    int* pos_list;
    int  count;
    bool b = XmListGetSelectedPos (_list, &pos_list, &count);
    pos = b ? pos_list[0] - 1 : -1;
    // -----------------^^^^^^ -- Correct for Motif's indexing
    if (b)
        XtFree ((char*) pos_list);
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection = pos;
    _selection.AddDependent (bind);
#elif defined(__X_YACL__)
    
#endif
}




bool UI_StringViewSingleSel::_SelectionChanged ()
{
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    if (_selection < 0 || _selection >= theModel.Size()) {
        StrViewBind bind (this, &UI_StringView::_SelectionChanged);
        _selection.RemoveDependent (bind);
        _selection = -1; 
        _selection.AddDependent (bind);
    }
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        SendMessage (_handle, LB_SETCURSEL, _selection, 0);
#elif defined(__OS2__)
    if (_handle)
        WinSendMsg (_handle, LM_SELECTITEM, (MPARAM) _selection.Value(),
                    (MPARAM) TRUE);
#elif defined(__X_MOTIF__)
    if (_list && _selection >= 0)
        XmListSelectPos (_list, _selection+1, FALSE);
    else
        XmListDeselectAllItems (_list);
#elif defined(__X_YACL__)
    // This is not a clean way to do this, but it'll work for now
    long l = _selection;
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection =  -1;
    _DoSelect (l);
    _selection.AddDependent (bind);
#endif
    return TRUE;
}

CL_Integer& UI_StringViewSingleSel::Selection ()
{
    return _selection;
}







#if defined(__X_YACL__)
void UI_StringViewSingleSel::_EmptySelection ()
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection = -1;
    _selection.AddDependent (bind);
}

UI_Rectangle UI_StringView::_ItemRectangle (long index)
{
    short textWidth = _shape.Width() - 5;
    if (_vBar->IsVisible())
        textWidth -= SCROLL_BAR_THICKNESS;
    return UI_Rectangle  (3, 2 + (index - _topElement) * _charHeight,
                          textWidth, _charHeight);
}

void UI_StringViewSingleSel::_HighlightSelection (UI_DrawingSurface& sfc)
{
    if (_selection >= 0) {
        short index = _selection - _topElement;
        if (index >= 0 && index < _visibleCount)
            sfc.InvertRectangle (_ItemRectangle (_selection));
    }

}


void UI_StringViewSingleSel::_DoSelect (long newSelection)
{
    if (newSelection != _selection) {
        UI_DisplaySurface& sfc = CreateDisplaySurface ();
        if (_selection >= _topElement &&
            _selection < _topElement + _visibleCount)
            sfc.InvertRectangle (_ItemRectangle (_selection));
        if (newSelection >= _topElement &&
            newSelection < _topElement + _visibleCount)
            sfc.InvertRectangle (_ItemRectangle (newSelection));
        DestroyDisplaySurface ();

        StrViewBind bind (this, &UI_StringView::_SelectionChanged);
        _selection.RemoveDependent (bind);
        _selection = newSelection;
        _selection.AddDependent (bind);
    }
}
#endif


// ----------------- Multiple selection StringViews ----------------------

UI_StringViewMultiSel::UI_StringViewMultiSel (UI_VisualObject* parent,  
                        const UI_Rectangle& shape,
                        UI_ViewID id)
: UI_StringView (parent, shape, TRUE, id)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind); // Notification code is not used
}



UI_StringViewMultiSel::UI_StringViewMultiSel
    (UI_VisualObject* parent, UI_StringSequence* model,
     const UI_Rectangle& shape, UI_ViewID id)
: UI_StringView (parent, model, shape, TRUE, id)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind);
}




#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_StringViewMultiSel::UI_StringViewMultiSel
    (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h)
: UI_StringView (parent, id, h)
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.AddDependent (bind);
}
#endif



bool UI_StringViewMultiSel::Select ()
{
    // Called in response to Event_Select generated when the user changes a
    // selection
    _UpdateSelection ();
    return FALSE; // So that the parent gets a chance to handle this event
}




void UI_StringViewMultiSel::_UpdateSelection ()
{
#if defined(__X_YACL__)
    return; // Nothing to do
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection.MakeEmpty ();
    long count = SendMessage (_handle, LB_GETSELCOUNT, 0, 0);
    if (count > 0) {
        int* buf = new int [count]; 
        SendMessage (_handle, LB_GETSELITEMS, count, (long)buf);
        for (long i = 0; i < count; i++)
            _selection.Add (buf[i]);
        delete buf;
    }
    _selection.AddDependent (bind);
#elif defined(__OS2__)
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection.MakeEmpty ();
    short index = LIT_FIRST;
    short pos;
    do {
        pos = SHORT1FROMMR (WinSendMsg (_handle, LM_QUERYSELECTION, (MPARAM)
                                  index, 0));
        if (pos == LIT_NONE) break;
        _selection.Add ((long) pos);
        index = pos;
    } while (1);
    _selection.AddDependent (bind);
#elif defined(__X_MOTIF__)
    StrViewBind bind (this, UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection.MakeEmpty ();
    int* pos_list;
    int  count;
    bool b = XmListGetSelectedPos (_list, &pos_list, &count);
    if (!b)
        count = 0;
    for (long i = 0; i < count; i++)
        _selection.Add (pos_list[i] - 1);
    //  ------------------------^^^^ -- Correct for Motif's indexing
    if (b)
        XtFree ((char*) pos_list);
    _selection.AddDependent (bind);
#endif
}



bool UI_StringViewMultiSel::_SelectionChanged ()
{
    // First, get rid of extraneous indices:
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    UI_StringSequence& theModel = *(UI_StringSequence*) _model;
    _selection.RemoveDependent (bind);
    _selection *= CL_IntegerSet (0, theModel.Size()-1);
    _selection.AddDependent (bind);

    // Now update the display:
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SendMessage (_handle, WM_SETREDRAW, FALSE, 0);
    SendMessage (_handle, LB_SELITEMRANGE, FALSE,
                 MAKELPARAM (0, theModel.Size()-1));
    CL_IntegerSetIterator itr (_selection);
    while (itr.More()) {
        long l = itr.Next();
        SendMessage (_handle, LB_SETSEL, TRUE, MAKELPARAM (l, 0));
    }
    SendMessage (_handle, WM_SETREDRAW, TRUE, 0);
#elif defined(__OS2__)
    short index = -1;
    short pos;
    CL_IntegerSet oldSelection;
    do {
        pos = SHORT1FROMMR (WinSendMsg (_handle, LM_QUERYSELECTION, (MPARAM)
                                  index, 0));
        if (pos == LIT_NONE) break;
        oldSelection.Add ((long) pos);
        index = pos+1;
    } while (1);
    CL_IntegerSet tmpSet = oldSelection - _selection;
    CL_IntegerSetIterator itr (tmpSet);
    while (itr.More())
        WinSendMsg (_handle, LM_SELECTITEM, (MPARAM) itr.Next(),
                    (MPARAM) FALSE);
    tmpSet = _selection - oldSelection;
    itr.Reset ();
    while (itr.More())
        WinSendMsg (_handle, LM_SELECTITEM, (MPARAM) itr.Next(), (MPARAM)
                    TRUE);
#elif defined(__X_MOTIF__)
    XmListDeselectAllItems (_list);
    CL_IntegerSetIterator itr (_selection);
    while (itr.More()) {
        long l = itr.Next();
        XmListSelectPos (_list, l+1, FALSE);
    }
#elif defined(__X_YACL__)
    // This is not a clean way to do this, but it'll work for now
    CL_IntegerSet tmpSet = _selection;
    _selection.RemoveDependent (bind);
    _selection.MakeEmpty ();
    CL_IntegerSetIterator itr (tmpSet);
    while (itr.More()) {
        long l = itr.Next();
        _DoSelect (l);
    }
    _selection.AddDependent (bind);
#endif
    return TRUE;
}



#if defined(__X_YACL__)
void UI_StringViewMultiSel::_EmptySelection ()
{
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection.MakeEmpty ();
    _selection.AddDependent (bind);
}

void UI_StringViewMultiSel::_HighlightSelection
    (UI_DrawingSurface& sfc)
{
    CL_IntegerSetIterator itr (_selection);
    while (itr.More()) {
        long l = itr.Next();
        short index = l - _topElement;
        if (index >= 0 && index < _visibleCount)
            sfc.InvertRectangle (_ItemRectangle (l));
    }

}

void UI_StringViewMultiSel::_DoSelect (long newSelection)
{
    // Modify the selection set
    StrViewBind bind (this, &UI_StringView::_SelectionChanged);
    _selection.RemoveDependent (bind);
    if (!_selection.Includes (newSelection))
        _selection.Add (newSelection);
    else
        _selection.Remove (newSelection);
    _selection.AddDependent (bind);


    // Update the display
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    if (newSelection - _topElement <= _visibleCount)
        sfc.InvertRectangle (_ItemRectangle (newSelection));
    DestroyDisplaySurface ();
}
#endif
