




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#include <string.h>
#if defined(__BORLANDC__) || defined(__WATCOMC__)
#    include <mem.h> // For memset
#else
#    include <memory.h>
#endif


#include "base/bytstrng.h"

#include "ui/stddlg.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/font.h"


UI_ViewID UI_StandardDialog (const char* message,
                             const char* box_title,
                             UI_CompositeVObject* parent,
                             UI_StandardDialogStyle style,
                             UI_StandardDialogIconStyle icon)
{
    ulong s = MB_MOVEABLE;
    switch (style) {
    case UIS_Ok:
        s |= MB_OK;
        break;
        
    case UIS_YesNo:
        s |= MB_YESNO;
        break;
        
    case UIS_YesNoCancel:
        s |= MB_YESNOCANCEL;
        break;

    case UIS_OkCancel:
    default:
        s |= MB_OKCANCEL;
        break;
    }

    switch (icon) {
    case UIS_Information:
        s |=  MB_INFORMATION;
        break;
        
    case UIS_Error:
        s |=  MB_ERROR;
        break;
        
    case UIS_Question:
        s |=  MB_QUERY;
        break;
        
    case UIS_Warning:
        s |=  MB_WARNING;
        break;

    }
    HWND hParent;
    if (parent) {
        hParent = parent->ViewHandle();
        s |= MB_APPLMODAL;
    }
    else
        hParent = HWND_DESKTOP;
    short ret_val = WinMessageBox
        (HWND_DESKTOP, hParent, message, box_title, 0, s);
    switch (ret_val) {
    case MBID_OK:
        ret_val = UI_IDOK;
        break;

    case MBID_CANCEL:
        ret_val = UI_IDCANCEL;
        break;

    case MBID_YES:
        ret_val = UI_IDYES;
        break;

    case MBID_NO:
        ret_val = UI_IDNO;
        break;

    default:
        break;
    }
    return ret_val;
}





CL_String UI_FileSelectDialog (UI_VisualObject* parent,
                               const char* initialDir,
                               const char* box_title,
                               const char* typeMask)
{
    FILEDLG fileDialog;
    memset (&fileDialog, 0, sizeof fileDialog); // Clear it out
    fileDialog.cbSize    = sizeof fileDialog;
    fileDialog.fl        = FDS_CENTER | FDS_OPEN_DIALOG;
    fileDialog.pszTitle  = (char*) box_title;
    fileDialog.pszIDrive = NULL;
    strcpy (fileDialog.szFullFile, initialDir);
    strcat (fileDialog.szFullFile, "\\");
    strcat (fileDialog.szFullFile, typeMask);
    short b = WinFileDlg (HWND_DESKTOP,
                         parent ? parent->ViewHandle() : HWND_DESKTOP,
                         &fileDialog);
    if (b != DID_OK || fileDialog.lReturn != DID_OK)
        return "";
    return fileDialog.szFullFile;
}



bool UI_FontDialog (UI_CompositeVObject* parent, UI_FontDesc& desc)
{
    FONTDLG fontDlg;
    char family[256];
    char font  [256];
    memset (&fontDlg, 0, sizeof fontDlg);
    memset (font, 0, sizeof font);
    fontDlg.cbSize         = sizeof fontDlg;
    fontDlg.hpsScreen      = WinGetPS (HWND_DESKTOP);
    fontDlg.pszFamilyname  = family;
    fontDlg.usFamilyBufLen = sizeof family;
    fontDlg.fl             = FNTS_CENTER | FNTS_INITFROMFATTRS;
    fontDlg.clrFore        = CLR_BLACK;
    if (WinFontDlg (HWND_DESKTOP, parent->ViewHandle(), &fontDlg) != DID_OK) {
        WinReleasePS (fontDlg.hpsScreen);
        return FALSE;
    }
    ulong style = 0;
    if (fontDlg.fAttrs.fsSelection & FATTR_SEL_ITALIC)
        style |= UIFont_Italic;
    if (fontDlg.fAttrs.fsSelection & FATTR_SEL_UNDERSCORE)
        style |= UIFont_Underline;
    if (fontDlg.fAttrs.fsSelection & FATTR_SEL_BOLD)
        style |= UIFont_BoldFace;
    if (fontDlg.fAttrs.fsSelection & FATTR_SEL_STRIKEOUT)
        style |= UIFont_StrikeOut;
    desc = UI_FontDesc (fontDlg.fAttrs.szFacename,
                        FIXEDINT (fontDlg.fxPointSize),
                        style);
    return TRUE;
}


