
/* I copied this code from Doug Young's Row example and performed  */
/* major surgery on it. */

#include    <Xm/XmP.h>
#include    <Xm/BulletinBP.h>
#include    "ui/support/x_motif/ycomp_p.h"

static void ClassInit  ();

static void Initialize ( Widget req, Widget new_w,
                         ArgList args, Cardinal *numArgs );
static void Resize ( Widget w );
static void ChangeManaged ( Widget w );
static void Redisplay ( Widget w, XEvent *event, Region region );

static XtGeometryResult GeometryManager ( Widget            w, 
                                          XtWidgetGeometry *request,
                                          XtWidgetGeometry *reply );
static XtGeometryResult QueryGeometry ( Widget            widget,
                                        XtWidgetGeometry *intended,
                                        XtWidgetGeometry *reply );

    
YCompositeClassRec yCompositeClassRec = {
{
    /* core_class members      */
    ( WidgetClass )    &xmBulletinBoardClassRec, /* superclass         */
    "YComposite",                          /* class_name         */
    sizeof ( YCompositeRec ) ,             /* widget_size        */
    ClassInit,                        /* class_initialize   */
    NULL,                             /* class_part_init    */  
    FALSE,                            /* class_inited       */  
    Initialize,                       /* initialize         */
    NULL,                             /* initialize_hook    */  
    XtInheritRealize,                 /* realize            */
    NULL,                             /* actions            */
    0,                                /* num_actions        */  
    NULL,                             /* resources          */
    0,                                /* num_resources      */
    NULLQUARK,                        /* xrm_class          */
    TRUE,                             /* compress_motion    */  
    XtExposeCompressMaximal,          /* compress_exposure  */  
    TRUE,                             /* compress_enterleave*/  
    FALSE,                            /* visible_interest   */
    NULL,                             /* destroy            */
    Resize,                           /* resize             */
    Redisplay,                        /* expose             */
    NULL,                             /* set_values         */
    NULL,                             /* set_values_hook    */
    XtInheritSetValuesAlmost,         /* set_values_almost  */
    NULL,                             /* get_values_hook    */  
    NULL,                             /* accept_focus       */
    XtVersion,                        /* version            */  
    NULL,                             /* callback_private   */
    XtInheritTranslations,            /* tm_table           */
    QueryGeometry,                    /* query_geometry     */  
    NULL,                             /* display_accelerator*/
    NULL,                             /* extension          */
},
{
    /* composite_class members */
    GeometryManager,                  /* geometry_manager   */
    ChangeManaged,                    /* change_managed     */
    XtInheritInsertChild,             /* insert_child       */  
    XtInheritDeleteChild,             /* delete_child       */  
    NULL,                             /* extension          */
},


{      /* constraint_class fields */
    NULL,                             /* resource list        */   
    0,                                /* num resources        */   
    0,                                /* constraint size      */   
    NULL,                             /* init proc            */   
    NULL,                             /* destroy proc         */   
    NULL,                             /* set values proc      */   
    NULL,                             /* extension            */
},
{      /* manager class     */
    XtInheritTranslations,            /* translations         */
    NULL,                             /* syn resources        */
    0,                                /* num syn_resources    */
    NULL,                             /* syn_cont_resources     */
    0,                                /* num_syn_cont_resources */
    XmInheritParentProcess,           /* parent_process       */
    NULL,                             /* extension            */    
},

{      /* bulletin_board class */
    0
},
    
{
    /* YComposite class members */
    0,                                /* empty              */  
}
};

WidgetClass yCompositeWidgetClass =  (WidgetClass) &yCompositeClassRec;

static void ClassInit ()
{
#ifdef DEBUG
    printf ("YComposite ClassInit called\n"); /* DEBUG */
#endif
    yCompositeClassRec.bulletin_board_class =
        xmBulletinBoardClassRec.bulletin_board_class;
}


static void Initialize ( Widget  request,
                         Widget    new_w ,
                         ArgList   args ,
                         Cardinal* numArgs  ) 
{
#ifdef DEBUG
    printf ("YComposite Initialize called, widget %08x\n", new_w); /* DEBUG */
#endif
} 
    
static void Resize ( Widget w) 
{
#ifdef DEBUG
    printf ("YComposite Resize called, widget %08x\n", w); /* DEBUG */
#endif
} 
    
                    
static void Redisplay ( Widget w, XEvent *event, Region region ) 
{
   /*
    * Redraw all gadgets.
    */
    
#ifdef DEBUG
    printf ("YComposite Redisplay called, widget %08x\n", w); /* DEBUG */
#endif
    _XmRedisplayGadgets ( w, event, region );
}


static XtGeometryResult QueryGeometry ( Widget            widget,
                                        XtWidgetGeometry *intended,
                                        XtWidgetGeometry *reply ) 
{
#ifdef DEBUG
    printf ("YComposite QueryGeometry called, widget %08x\n", widget); /* DEBUG */
#endif
    return XtGeometryYes;
}
                                        
static XtGeometryResult GeometryManager ( Widget             widget, 
                                          XtWidgetGeometry  *request,
                                          XtWidgetGeometry  *reply ) 
{
#ifdef DEBUG
    printf ("YComposite GeometryManager called for %s mode 0x%04x\n",
            XtName(widget), request->request_mode); /* DEBUG */
    printf ("    Request: x %d y %d w %d h %d\n", request->x, request->y,
            request->width, request->height); /* DEBUG */
    printf ("    Reply: x %d y %d w %d h %d\n", reply->x, reply->y,
            reply->width, reply->height); /* DEBUG */
#endif
    if (request->request_mode & XtCWQueryOnly) {
#ifdef DEBUG
        printf ("      YComposite GeometryManager: QueryOnly\n"); /* DEBUG */
#endif
        return XtGeometryYes;
    }
#ifdef DEBUG
        printf ("      YComposite GeometryManager: Change\n"); /* DEBUG */
#endif

    /*
    XtResizeWidget (widget, request->width, request->height,
                    XtBorderWidth (widget));
    XtMoveWidget   (widget, request->x, request->y);
    *reply = *request; 
    return XtGeometryDone;
    */

    return XtGeometryYes; 
}
                                                    
static void ChangeManaged ( Widget child ) 
{
    YCompositeWidget rw = ( YCompositeWidget ) child; 
    _XmNavigChangeManaged( child );    
#ifdef DEBUG
    printf ("YComposite ChangeManaged called, widget %08x\n", child); /* DEBUG */
#endif
}
