

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#endif
#include <X11/Xlib.h>


#include "base/bytstrng.h"

#include "ui/stddlg.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/dialog.h"
#include "ui/pushbtn.h"
#include "ui/label.h"


const short StdDialogWidth = 300, StdDialogHeight = 150;


class StandardDialog: public UI_Dialog {

    // A private class.
    
public:
    StandardDialog (UI_CompositeVObject* parent, const UI_Rectangle& shape)
        : UI_Dialog (parent, NULL, shape) {};

protected:
    bool HandleChildEvent (const UI_Event& e) {return TRUE;};
    // Don't send events up the tree.
    
};


UI_ViewID UI_StandardDialog (const char* message,
                             const char* box_title,
                             UI_CompositeVObject* parent,
                             UI_StandardDialogStyle style,
                             UI_StandardDialogIconStyle icon)
{
    // Center the dialog in the parent
    short width = StdDialogWidth, height = StdDialogHeight;
    short x = 0, y = 0, pw, ph;
    UI_Rectangle shape;
    UI_Application* theApp = YACLApp();
    if (parent) {
        UI_Rectangle& parentShape = parent->Shape();
        pw = parentShape.Width();
        ph = parentShape.Height();
        x = parentShape.Left();
        y = parentShape.Top();
    }
    else {
        UI_Rectangle parentShape = theApp->ScreenRect();
        pw = parentShape.Width();
        ph = parentShape.Height();
    }
    shape = UI_Rectangle (x + maxl ((pw - width)/2, 0),
                          y + maxl ((ph - height)/2, 0), width, height);
    StandardDialog* dlg = new StandardDialog (parent, shape);
    dlg->Title() = box_title;
    UI_Label* lbl = new UI_Label
        (dlg, UI_Rectangle (50, 20, StdDialogWidth - 100, 30), 10);
    lbl->Title() = message;
    UI_PushButton* btn1, *btn2, *btn3;
    switch (style) {
    case UIS_Ok:
        btn1 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 - 30,  80, 60, 30), UI_IDOK);
        btn1->Title() = "Ok";
        break;

    case UIS_OkCancel:
        btn1 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 - 70,  80, 60, 30), UI_IDOK);
        btn1->Title() = "Ok";
        btn2 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 + 10,  80, 60, 30),
             UI_IDCANCEL);
        btn2->Title() = "Cancel";
        break;

    case UIS_YesNo:
        btn1 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 - 70,  80, 60, 30),
             UI_IDYES);
        btn1->Title() = "Yes";
        btn2 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 + 10,  80, 60, 30),
             UI_IDNO);
        btn2->Title() = "No";
        dlg->AddDialogEvent (UI_IDYES, Event_Select);
        dlg->AddDialogEvent (UI_IDNO,  Event_Select);
        break;

    case UIS_YesNoCancel:
        btn1 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 - 110, 80, 60, 30),
             UI_IDYES);
        btn1->Title() = "Yes";
        btn2 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 -  30, 80, 60, 30), UI_IDNO);
        btn2->Title() = "No";
        btn3 = new UI_PushButton
            (dlg, UI_Rectangle (StdDialogWidth/2 +  50, 80, 60, 30),
             UI_IDCANCEL);
        btn3->Title() = "Cancel";
        dlg->AddDialogEvent (UI_IDYES, Event_Select);
        dlg->AddDialogEvent (UI_IDNO,  Event_Select);
        break;

    }
    UI_DialogEventDescriptor d = dlg->ExecuteModal ();
    YACLApp()->Destroy (dlg);
    return d.id;
}

CL_String UI_FileSelectDialog (UI_VisualObject* parent,
                               const char* initialDir,
                               const char* box_title,
                               const char* typeMask)
{
}




bool UI_FontDialog (UI_CompositeVObject* parent, UI_FontDesc& desc)
{
    return FALSE;
}


