

#include <X11/Xlib.h>

#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/dsplsurf.h"
#include "ui/dsinmem.h"
#include "ui/brush.h"
#include "ui/pen.h"
#include "ui/shadorec.h"
#include "ui/support/x_yacl/window.h"


YVE_Window::YVE_Window (UI_VisualObject* vObj)
: _vObj (vObj)
{
    Display* dp = YACLApp()->AppDisplay();
    int screenNo = DefaultScreen (dp);
    const UI_Rectangle& shape = vObj->Shape();
    UI_VisualObject* parent = vObj ? vObj->Parent() : NULL;
    Window pw = parent ? parent->ViewHandle() : RootWindow (dp, screenNo);
    _window = XCreateSimpleWindow
        (dp, pw, shape.Left(), shape.Top(),
         shape.Width(), shape.Height(), 0,
         BlackPixel (dp, screenNo), vObj->Background().XPixel());
    XSelectInput (dp, _window,
                  EnterWindowMask | LeaveWindowMask |
                  PointerMotionMask |
                  Button1MotionMask | Button2MotionMask | Button3MotionMask |
                  ExposureMask |
                  KeyPressMask | KeyReleaseMask |
                  ButtonPressMask | ButtonReleaseMask);
}


YVE_Window::~YVE_Window ()
{
    XDestroyWindow (YACLApp()->AppDisplay(), _window);
}

void YVE_Window::Reshape (const UI_Rectangle& )
{
}






YVE_StringWindow::YVE_StringWindow (UI_VisualObject* vObj)
: YVE_Window (vObj)
{
}





const short SHADOW_THICKNESS = 2;


void YVE_StringWindow::Draw (const char* content, UI_ReliefStyle style,
                             UI_TextStyle tStyle)
{
    UI_Rectangle& shape = _vObj->Shape();
    short xOffs = 0, yOffs = 0;
    long w = shape.Width(), h = shape.Height();
    UI_DwgSurfaceInMemory memDS (w, h);
    UI_DisplaySurface& sfc = _vObj->CreateDisplaySurface ();
    memDS.ColorDisplay (_vObj->Background());

    switch (style) {
    case UIRelief_Raised: {
        UI_ShadowRectangle r (0, 0, w, h, UI_ShadowRectangle::Raised,
                              SHADOW_THICKNESS);
        r.DrawOn (memDS);
        xOffs = 2 * SHADOW_THICKNESS;
        yOffs = 2 * SHADOW_THICKNESS + 2;
        break;
    }
        
    case UIRelief_Recessed: {
        UI_ShadowRectangle r (0, 0, shape.Width(), shape.Height(),
                              UI_ShadowRectangle::Recessed, SHADOW_THICKNESS);
        r.DrawOn (memDS);
        xOffs = 2 * SHADOW_THICKNESS + 4; // Note that these constants are
                                          // larger, by 4, than the ones in
                                          // the Raised case, because we
                                          // want the recessed effect.
        yOffs = 2 * SHADOW_THICKNESS + 6;
        break;
    }
        
    case UIRelief_Plain:
        // Erase everything
        memDS.ColorRectangle (UI_Rectangle (0, 0, shape.Width(),
                                            shape.Height()),
                              _vObj->Background());
        break;
    };

    UI_Font& font =  memDS.Font();
    font = sfc.Font().Descriptor();
    UI_Rectangle textRect (xOffs, yOffs, shape.Width()  - 2*xOffs,
                           shape.Height() - 2*yOffs);
    memDS.Pen() = UI_PenDescriptor (1, _vObj->Foreground(), UIPen_Solid);
    memDS.WriteString (content, textRect, tStyle);
    
    memDS.CopyTo (sfc);
}


