



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#elif defined(__OS2__)
#    if defined(__GNUC__)  // EMX compiler
#        define OS2EMX_PLAIN_CHAR
#    endif
#    define INCL_DOSMEMMGR
#    define INCL_PM
#    include <os2.h>
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/Text.h>
#endif


#include "ui/textedit.h"

#if defined(__GNUC__)
template class CL_Binding0<UI_TextEditor>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_TextEditor>;
#endif



UI_TextEditor::UI_TextEditor
    (UI_VisualObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_StringEditor (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style |= ES_MULTILINE | WS_VSCROLL | WS_HSCROLL;
#elif defined(__OS2__)
    _style = WS_VISIBLE | MLS_HSCROLL | MLS_VSCROLL | MLS_BORDER |
        MLS_WORDWRAP;
#elif defined(__X_MOTIF__)
    _text = NULL;
#endif
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_TextEditor::UI_TextEditor (UI_CompositeVObject* parent, UI_ViewID id,
               UI_ViewHandle h)
: UI_StringEditor (parent, id, h)
{
}
#endif


#if defined(__X_MOTIF__)
void UI_TextEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    // We don't call the underlying _SetupStyle as it ony sets
    // the dimensions for the texteditor itself
    // UI_SimpleVObject::_SetupStyle (arg, argn);
    short x = _shape.Left   ();
    short y = _shape.Top    ();
    short w = _shape.Width  ();
    short h = _shape.Height ();

    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
    XtSetArg (arg[argn], XmNeditMode, XmMULTI_LINE_EDIT); argn++;
    XtSetArg (arg[argn], XmNwordWrap, True); argn++;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
}
    
#endif

void UI_TextEditor::MakeVisible ()
{
    UI_SimpleVObject::MakeVisible ();

#if defined(__X_MOTIF__)
    // Somehow the dimensions of a scrolled text are not correct if
    // set before XtManageChild(). So we set it every time one calls
    // MakeVisible().

    Arg arg [20];
    short argn = 0;
    short x = _shape.Left   ();
    short y = _shape.Top    ();
    short w = _shape.Width  ();
    short h = _shape.Height ();

    if (_text) {
        XtManageChild   (_text);
        XtSetArg (arg [ argn ], XtNx,     x); argn++;
        XtSetArg (arg [ argn ], XtNy,     y); argn++;
        XtSetArg (arg [ argn ], XtNheight,h); argn++;
        XtSetArg (arg [ argn ], XtNwidth, w); argn++;
        XtSetValues (_xwidget, arg, argn);
    }
    
#endif
}

void UI_TextEditor::MakeInvisible ()
{
#if defined(__X_MOTIF__)
    if (_text)
        XtUnmanageChild   (_text);
#endif
    UI_SimpleVObject::MakeInvisible ();
}
    
bool UI_TextEditor::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_SimpleVObject::MakeVisualElement();
#elif defined(__OS2__)
    bool b = UI_SimpleVObject::MakeVisualElement();
    return b;
#elif defined(__X_MOTIF__)

    // This code is copied from that of SimpleVObject, except that we use
    // XmCreateScrolledText instead of XtCreateWidget, because the scroll
    // bar does not seem to be displayed otherwise.

    // The other problem: all sizing stuff must be done on the surrounding
    // XmScrolledWindow which is implicit created by XmCreateScrolledText
    // So we set the _xwidget to the ScrolledWindow and keep the handle
    // for the text itself in _text
    
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = (UI_VisualObject*) _parent;
    Widget pw = (Widget) p->ViewHandle();

    Arg arg [20];
    short argn = 0;

    CL_String instance_name = InstanceName();
    const char* inst_name   = instance_name.AsPtr();

    _SetupStyle (arg, argn);

    _text = XmCreateScrolledText (pw, (char*) inst_name, arg, argn);
    _xwidget = XtParent(_text);
    _FontChanged (); // Force font update
    return TRUE;
#endif
}



UI_WindowClass UI_TextEditor::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "edit";
#elif defined(__OS2__)
    return WC_MLE;
#elif defined(__X_MOTIF__)
    return  xmTextWidgetClass;
#endif
}


bool UI_TextEditor::SetLengthLimit (long n)
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_MOTIF__)
    return UI_StringEditor::SetLengthLimit (n);
#elif defined (__OS2__)
    _limit = n;
    if (_handle)
        WinSendMsg (_handle, MLM_SETTEXTLIMIT, (MPARAM) n, 0);
    return TRUE;
#endif
}


CL_Object& UI_TextEditor::Model ()
{
#if defined(__OS2__)
    if (!_handle)
        return *_model;
    long n = (long) WinSendMsg(_handle, MLM_QUERYTEXTLENGTH, NULL, NULL);
    n = (long) WinSendMsg(_handle, MLM_QUERYFORMATTEXTLENGTH, 0,
                          MPFROMLONG (n));
    char* buf = new char [n+1];
//     WinSendMsg (_handle, MLM_SETIMPORTEXPORT, (MPARAM) buf, (MPARAM) n);
// 
//     long offset = 0;
//     WinSendMsg (_handle, MLM_EXPORT,  MPFROMLONG(&offset), MPFROMLONG (&n));
    WinQueryWindowText (_handle,  n+1, buf);
    buf[n] = '\0';
    _SetModelValue (CL_String (buf));
    delete [] buf;
    return *_model;
#else
    return UI_StringEditor::Model();
#endif
}


CL_Interval& UI_TextEditor::Selection ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_MOTIF__)
    return UI_StringEditor::Selection ();
#elif defined(__OS2__)
    long low = (long) WinSendMsg  (_handle, MLM_QUERYSEL,
                                     (MPARAM) MLFQS_MINSEL, 0);
    low = (long) WinSendMsg(_handle, MLM_QUERYFORMATTEXTLENGTH, 0,
                             MPFROMLONG (low));
    long hi  = (long) WinSendMsg  (_handle, MLM_QUERYSEL,
                                     (MPARAM) MLFQS_MAXSEL, 0);
    hi = (long) WinSendMsg(_handle, MLM_QUERYFORMATTEXTLENGTH, 0,
                            MPFROMLONG (hi));
    
//     // OS/2 doesn't seem to count the end-of-line pair as two characters
//     // when it responds to the MLM_QUERYSEL message. So I have to work
//     // around it :-(
//     long newlineCount1 = 0;
//     CL_String& model = (CL_String&) Model();
//     long i;
//     for (i = 0; i < low; i++)
//         if (model(i) == '\r' && model(i+1) == '\n')
//             newlineCount1++;
//     long newlineCount2 = 0;
//     for (i = low; i < hi-1; i++)
//         if (model(i) == '\r' && model(i+1) == '\n')
//             newlineCount2++;
//     low += newlineCount1;
//     hi  += newlineCount2;
    CL_Binding0<UI_TextEditor> bind (this, &UI_TextEditor::_SelectionChanged);
    _selection.RemoveDependent (bind);
    _selection = CL_Interval (low, hi - 1);
    _selection.AddDependent (bind);
    return _selection;
#endif
}


#if defined(__OS2__)
bool UI_TextEditor::_ModelChanged ()
{
    if (!_handle)
        return TRUE;
    CL_String& theModel = *(CL_String*) _model;
//     WinSendMsg (_handle, MLM_SETIMPORTEXPORT, MPFROMP (theModel.AsPtr()),
//                 MPFROMLONG (size));
//     long offset = 0;
//     WinSendMsg (_handle, MLM_IMPORT, MPFROMP (&offset), MPFROMLONG (size));
    WinSetWindowText (_handle, theModel.AsPtr());
    return TRUE;
}

bool UI_TextEditor::_SelectionChanged ()
{
    if (_handle) {
        WinSendMsg (_handle, MLM_SETSEL, (MPARAM)_selection.Low(),
                    (MPARAM) (_selection.High()+1));
    }
    return TRUE;
}
#endif

