



#ifndef _textedit_h_ /* Wed Sep 28 08:01:23 1994 */
#define _textedit_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// TextEditor is a SimpleVObject that supports  editing a multi-line
// block  of   text  contained  in   its  model,  which   is  a  {\tt
// CL_String}. The  selection  on the model  is  a {\tt CL_Interval},
// i.e.,   the  positions of  the   left and  right  ends  of the substring
// currently selected.


#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/stred.h"


class YACL_UI UI_TextEditor: public UI_StringEditor {

public:

    virtual void MakeInvisible ();
    // Make the TextEditor invisible. This overrides the inherited method.
    
    virtual void MakeVisible ();
    // Make the TextEditor visible. This overrides the inherited method.

    bool MakeVisualElement ();
    // Override the inherited method. Under Windows and OS/2, the
    // implementation  simply forwards the call to the inherited method.
    // Under Motif, the implementation creates a ScrolledText widget.

    UI_TextEditor (UI_VisualObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1);
    // Constructor: create a TextEditor with the given parent, shape and
    // view id.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_TextEditor (UI_CompositeVObject* parent, UI_ViewID id,
                   UI_ViewHandle h); 
    // [MS-Windows-specific, for YACL internal use only] Resource-based
    // construction.

#endif

    CL_Object& Model ();
    // Return a reference to the TextEditor's model, which is a CL_String
    // containing all the lines in the TextEditor.
    
    CL_Interval& Selection ();
    // Return a reference to a {\tt CL_Interval} containing the range of
    // positions selected. Modifying the return value causes a
    // corresponding setting of selection in the displayed string.

    bool SetLengthLimit (long n);
    // Make the TextEditor enforce a  limit user type-in to $n$
    // characters.

    const char* ClassName() const {return "UI_TextEditor";};

    UI_WindowClass WindowClass () const;
    
#if defined(__OS2__)

private:

    virtual bool _SelectionChanged ();
    // Called when the application modifies the return value of the
    // {\tt Selection} method.

    virtual bool _ModelChanged ();
    // OS/2-specific override of the inherited method.
    
#elif defined (__X_MOTIF__)

protected:
    void _SetupStyle (void* arg, short& argn);
    // [X-Motif-specific. Internal use only] Set up TextEditor-specific
    // Motif resources just before widget creation.

#endif
    
};





#endif /* _textedit_h_ */
