




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/toglbtn.h"
#include "ui/cntroler.h"
#include "ui/composit.h"

#include "base/integer.h"


//------------------------------------------------------------------
//                     CLASS TOGGLEBUTTON
//------------------------------------------------------------------

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#    define TOGGLE_BUTTON_STYLE \
     BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP 
#elif defined(__OS2__)
#    define TOGGLE_BUTTON_STYLE BS_AUTOCHECKBOX | WS_VISIBLE
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/ToggleB.h>
#elif defined(__X_YACL__)
#    include "ui/shadorec.h"
#    include "ui/dsplsurf.h"
#    include "ui/support/x_yacl/window.h"
#endif



UI_ToggleButton::UI_ToggleButton
    (UI_VisualObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_SimpleVObject (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _style = TOGGLE_BUTTON_STYLE;
#elif defined(__X_YACL__)
    _visualElement = NULL;
#endif
    _model = new CL_Integer;
    _borderShown = FALSE;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_ToggleButton::UI_ToggleButton (UI_VObjCollection* parent, UI_ViewID
                                  id, UI_ViewHandle h) 
: UI_SimpleVObject (parent, id, h)
{
    _model = new CL_Integer; 
    _borderShown = FALSE;
}
#endif




CL_Object& UI_ToggleButton::Model ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0)
        _SetModelValue (CL_Integer (SendMessage (_handle,
                                                BM_GETCHECK, 0, 0L)));
#elif defined(__OS2__)
    if (_handle) {
        long val = (long) WinSendMsg (_handle, BM_QUERYCHECK, 0, 0L);
        _SetModelValue (CL_Integer (val));
    }
#elif defined (__X_MOTIF__)
    if (_xwidget)
        _SetModelValue (CL_Integer (XmToggleButtonGetState (_xwidget)));
#endif
    return *_model;
}





bool UI_ToggleButton::_ModelChanged ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0) {
        SendMessage (_handle, BM_SETCHECK,
                     ((CL_Integer*) _model)->Value() > 0 ? 1 : 0, 0L);
    }
#elif defined(__OS2__)
    if (_handle) {
        MPARAM val = MPFROM2SHORT (((CL_Integer *) _model)->Value () > 0
                                   ? TRUE : FALSE, 0);
        WinSendMsg (_handle, BM_SETCHECK, val, NULL);
    }
#elif defined (__X_MOTIF__)
    if (_xwidget)
        XmToggleButtonSetState (_xwidget, ((CL_Integer*) _model)->Value(),
                                FALSE);
#elif defined(__X_YACL__)
    if (_visible && _enabled)
        DrawVisualElement ();
#endif
    return TRUE;
}



void UI_ToggleButton::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
    _ModelChanged (); // Dummy call to force initial setting
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // We have to subclass the button *after* the Ctl3d subclass in order to
    // paint its background properly.
    _Controller->SubclassControl (_handle, (FARPROC) YACLBtnProc);
#elif defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNvalueChangedCallback, 
                   &UI_ToggleButton::SelectionCallback, (XtPointer) this);
    XtVaSetValues (_xwidget, XmNmarginWidth, 0, XmNmarginHeight, 0, NULL);
    XtVaSetValues (_xwidget, XmNalignment, XmALIGNMENT_BEGINNING, NULL);
    // If we try to set the alignment at creation time (i.e., in
    // _SetupStyle), Motif complains!
#endif
}



UI_WindowClass UI_ToggleButton::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "button";
#elif defined(__OS2__)
    return WC_BUTTON;
#elif defined(__X_MOTIF__)
    return xmToggleButtonWidgetClass;
#endif
}



#if defined (__X_MOTIF__)
void UI_ToggleButton::SelectionCallback (Widget , void* client, void* call)
{
    UI_ToggleButton* btn = (UI_ToggleButton *) client;
    int value = ((XmToggleButtonCallbackStruct*) call)->set;
    btn->_SetModelValue (CL_Integer(value));
    _Controller->AddEvent (new UI_Event (Event_Select, btn, btn));
}
#endif


#if defined(__X_YACL__)
void UI_ToggleButton::DrawVisualElement ()
{
    if (!_window || !_visible)
        return;
    CL_Integer value = *(CL_Integer*) _model;
    UI_Rectangle pictureRect (4, 4, 12, 12);
    UI_DisplaySurface& sfc = CreateDisplaySurface();
    if (value == 0) {
        // Draw in unselected state
        UI_ShadowRectangle r (pictureRect, UI_ShadowRectangle::Raised, 2,
                              FALSE);
        r.DrawOn (sfc);
    }
    else {
        // Draw in selected state
        UI_ShadowRectangle r (pictureRect, UI_ShadowRectangle::Recessed, 2,
                              FALSE);
        UI_DisplaySurface& sfc = CreateDisplaySurface();
        r.DrawOn (sfc);
        sfc.ColorRectangle (UI_Rectangle (7, 7, 6, 6),
                            UI_Color (0.804, 0.361, 0.361));
    }
    short ht = Font().Height();
    sfc.WriteString
        (_title, UI_Rectangle (20, maxl (1, 10 - ht/2),
                               _shape.Width() - 20, ht));
    DestroyDisplaySurface();
}

bool UI_ToggleButton::HandleEvent (UI_Event* e)
{
    if (!e)
        return FALSE;
    if (!_enabled)
        return ProcessEvent (e); // Just in case a child class needs to do
                                 // something with this event
    UI_EventType type = e->Type();
    switch (type) {
    case Event_LButtonPress: {
        CL_Integer value = *(CL_Integer*) _model;
        _SetModelValue (CL_Integer (1 - value));
        DrawVisualElement();
        UI_Event e (Event_Select, this, this);
        _Controller->DispatchEvent (&e);
        break;
    }
    
    case Event_Paint:
        DrawVisualElement();
        break;

    default:
        break;
    }
    return ProcessEvent (e);
}

bool UI_ToggleButton::MakeVisualElement ()
{
    _visualElement = new YVE_Window (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
}


bool UI_ToggleButton::_TitleChanged ()
{
    if (_visible && _enabled && _window)
        DrawVisualElement();
}
#endif

