
#ifndef _uidefs_h_ /* Sat Dec 25 09:21:26 1993 */
#define _uidefs_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if !defined(__MS_WINDOWS__) && !defined(__MS_WIN32__) && !defined(__OS2__)
#if !defined(__X_YACL__) && !defined(__X_MOTIF__)
#error uidefs.h: unsupported platform
#endif
#endif

// --------------------- uidefs.h -----------------------------
//
//      Basic declarations for the user interface framework
//
// ------------------------------------------------------------


#include "base/defs.h"

// Let's worry about the DLL stuff first:
#if defined(BUILD_DLL)
#    if defined(__MS_WINDOWS__) || defined(WINDOWS) \
    || defined(__MS_WIN32__) || defined(WIN32)
#        undef  YACL_BASE
#        undef  YACL_BASEFUNC
#        define YACL_BASE     _import
#        define YACL_BASEFUNC _import
#        define YACL_UI       _export
#        define YACL_UIFUNC   _export
#    elif defined(__OS2__)
#        undef  YACL_BASE
#        undef  YACL_BASEFUNC
#        define YACL_BASE    
#        define YACL_BASEFUNC
#        define YACL_UI       _export
#        define YACL_UIFUNC   _export
#    else
#        error 'Cannot build DLL for' YACLPLATFORM
#    endif
#elif defined(USE_YACL_DLL)
#    if defined(__MS_WIN32__)
#        define YACL_UI       _import
#        define YACL_UIFUNC   _import
#    endif
#endif

#ifndef YACL_UI
#    define YACL_UI
#    define YACL_UIFUNC
#endif


// The View Id: a "persistent" way of identifying visual objects
typedef long UI_ViewID;

// The View Handle is a platform-specific handle to a VisualObject. Its
// typedef depends on platform. The WindowClass is a platform-specific
// typedef that establishes the class of window.

# if defined(__MS_WINDOWS__)

// ----------------- Windows-specific definitions: -----------------------

    typedef long            UI_ViewHandle;
    typedef const char*     UI_WindowClass;
    typedef ulong           UI_Pid; // Process id

#   include <windows.h>
#   define NativeEventStruct MSG
#   define BTNGROUP_PROPERTY1 "YACLBtnGrp1"
#   define BTNGROUP_PROPERTY2 "YACLBtnGrp2"

# elif defined(__MS_WIN32__)

// ----------------- Win32-specific definitions: -----------------------

#   include <windows.h>
    typedef HANDLE          UI_ViewHandle;
    typedef const char*     UI_WindowClass;
    typedef HANDLE          UI_Pid; // Process id
    
#   include <windows.h>
#   define NativeEventStruct MSG
#   define BTNGROUP_PROPERTY1 "YACLBtnGrp1"
#   define BTNGROUP_PROPERTY2 "YACLBtnGrp2"

# elif defined(__OS2__)

// ----------------- OS/2-specific definitions: -----------------------

#   if defined(__GNUC__)  // EMX compiler
#       define OS2EMX_PLAIN_CHAR
#   endif
#   define INCL_PM
#   include <os2.h>
    typedef QMSG          NativeEventStruct;
    typedef ulong         UI_ViewHandle;
    typedef const char*   UI_WindowClass;
    typedef ulong         UI_Pid; // Process id
#   define OS2_MENU_BAR_HEIGHT 24
    
# elif defined(__X_MOTIF__)

// ----------------- X-Motif- specific definitions: ------------------

    extern "C" {
    // These are stolen from X11/Intrinsic.h. They might have to be fixed up
    // in future versions of X, if the definitions of "Widget" and
    // "WidgetClass" change. We refrain from including Intrinsic.h here so
    // as to minimize preprocessing time when compiling applications.
    struct _WidgetRec;
    struct _WidgetClassRec;
    }
    typedef _WidgetClassRec*   UI_WindowClass;
    typedef struct _WidgetRec* UI_ViewHandle;
    typedef ulong              UI_Pid; // Process id
#   include <X11/Xlib.h>
#   define NativeEventStruct XEvent

#elif defined(__X_YACL__)
#   include <X11/Xlib.h>
#   define NativeEventStruct XEvent

    typedef long               UI_WindowClass;
    typedef Window             UI_ViewHandle;
    typedef ulong              UI_Pid; // Process id

#endif


#if defined(__MS_WINDOWS__)
    typedef  long UI_DwgSurfHandle;
#elif defined(__MS_WIN32__)
    typedef  HANDLE UI_DwgSurfHandle;
#elif defined(__OS2__)
    typedef  ulong UI_DwgSurfHandle;
#elif defined(__X_MOTIF__)  || defined(__X_YACL__)
    struct _XGC;
    typedef struct _XGC* UI_DwgSurfHandle;
#endif



// --------------------- Useful enumerations -----------------------

enum UI_ExtTextStyle {
    UIText_TopLeft = 0, UIText_TopCenter,     UIText_TopRight,
    UIText_CenterLeft,  UIText_CenterCenter,  UIText_CenterRight,
    UIText_BottomLeft,  UIText_BottomCenter,  UIText_BottomRight
};

enum UI_TextStyle {
    UIText_Left   = UIText_TopLeft,
    UIText_Right  = UIText_TopRight,
    UIText_Center = UIText_TopCenter
};

enum UI_ReliefStyle {UIRelief_Plain, UIRelief_Raised, UIRelief_Recessed,
                     UIRelief_Embossed, UIRelief_Grooved };
    

// Standard id's of the buttons on  dialogs:
enum UI_StdButtonEnum {
    UI_IDOK = 1, UI_IDCANCEL, UI_IDYES,  UI_IDNO
};




// ----------------------- Misc stuff -----------------------------

//[ Global
struct UI_RectangleStruct {
    long x, y, w, h;  // h = height, w = width
};
// A convenient definition of a rectangle.
//] Global

extern char _YACLWindowClassName[]; // Defined in cntroler.cxx
extern char _YACLSimpleClassName[]; // Defined in cntroler.cxx

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
extern char _YACLMDIFrameClassName[]; // Defined in cntroler.cxx
extern char _YACLMDIChildClassName[]; // Defined in cntroler.cxx
#endif


#if !defined(__MS_WINDOWS__) && !defined(FAR)
#  define FAR
#endif



#if defined(CHECK_LEAKS)
#include "base/memory.h"     // DEBUG only!
#endif





#endif /* _uidefs_h_ */

