



#ifndef _vector_h_ /* Mon May  8 08:52:42 1995 */
#define _vector_h_

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// This class represents a {\it vector\/} in two-dimensional space. A
// vector is a directed line segment from the origin to a given point.
// Vectors are used to translate a graphic object to another point in 2-d
// space. The co-ordinate space of a vector is an abstract 2-d space not
// tied to any particular DrawingSurface or VisualObject.

#include "ui/uidefs.h"

class YACL_UI UI_Point;

class YACL_UI UI_Vector {

public:
    UI_Vector (long x, long y) {_x = x; _y = y;};
    // Construct a directed line segment from the origin to the point
    // $(x,y)$.

    UI_Vector (const UI_Point& p);
    // Construct a vector to the given point.
    
    UI_Vector  operator+  (const UI_Vector& v) const
        {UI_Vector w = *this; w += v; return w;};
    // Return a Vector whose value is this Vector translated by {\tt v}.

    UI_Vector  operator-  (const UI_Vector& v) const
        {UI_Vector w = *this; w -= v; return w;};
    // Return a Vector whose value is this Vector translated by the
    // negation of {\tt v}.

    UI_Vector& operator+= (const UI_Vector& v)
        {_x += v._x; _y += v._y; return *this; };
    // Translate this Vector by {\tt v}. 
    
    UI_Vector& operator-= (const UI_Vector& v)
        {_x -= v._x; _y -= v._y; return *this; };
    // Translate this Vector by the negation of {\tt v}.

    bool operator== (const UI_Vector& v) const
        {return _x == v._x && _y == v._y;};
    // Tell if {\tt v} equals this Vector.
    
    long X() const {return _x;};
    // Return the $x$ co-ordinate of this Vector.

    long Y() const {return _y;};
    // Return the $y$ co-ordinate of this Vector.

private:
    long _x;
    long _y;
};




#endif /* _vector_h_ */
