



#ifndef _viewdesc_h_ /* Sun Dec 11 15:52:04 1994 */
#define _viewdesc_h_


// The view descriptor structure.

#include "ui/uidefs.h"

enum UI_ViewType {
    View_None = 0,             View_ExOrToggleButton, View_Dialog,  
    View_PushButton,           View_ToggleButton,     View_StringViewSingle,
    View_StringViewMulti,      View_Label,            View_TextView,
    View_MenuItem,             View_Composite,        View_StringEditor,
    View_OrButtonGroup,        View_ExOrButtonGroup,  View_HScrollBar,
    View_VScrollBar,           View_ComboBox,         View_BitmapPushButton,
    View_BitmapToggleButton
};

// The ViewDescriptor is a passive representation of a single view object.
// If this descriptor is that of a composite, then the "enclosed" field
// points to the array of children, if any. 

struct UI_ViewDescriptor {
    UI_ViewType type;
    UI_ViewID   id;           // Id must be specified
    UI_RectangleStruct shape; // Shape of this view. Origin is specified wrt
                              // the parent's rectangle.
    bool        tab_stop;     // Is this view a tab stop in the parent?
    char*       title;        // Title
    
    UI_ViewDescriptor* enclosed; // NULL for SimpleVObjs. For composite
                                 // children, must point to an array of
                                 // ViewDescriptors, with the last one having
                                 // a 0 for id and a View_None for type.
};


#endif /* _viewdesc_h_ */
