

// Demo of the YACL 3-d labels

#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/3dlabel.h"
#include "ui/font.h"

enum {
    LABEL1 = 101,
    LABEL2,
    LABEL3,
    LABEL4
};


class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();


protected:
    void Initialize ();

    void Finalize ();
};

AppWindow::AppWindow ()
: UI_CompositeVObject (NULL, UI_Rectangle (300, 50, 300, 200))
{
    UI_3DLabel* l1 = new UI_3DLabel (this, UI_Rectangle (20, 10, 260, 35),
                                     LABEL1, UI_3DLabel::Plain);
    UI_3DLabel* l2 = new UI_3DLabel (this, UI_Rectangle (20, 50, 260, 35),
                                     LABEL2, UI_3DLabel::Raised);
    UI_3DLabel* l3 = new UI_3DLabel (this, UI_Rectangle (20, 90, 260, 35),
                                     LABEL3, UI_3DLabel::Recessed);
    UI_3DLabel* l4 = new UI_3DLabel (this, UI_Rectangle (20, 130, 260, 35),
                                     LABEL4, UI_3DLabel::Embossed);

    l1->Title()    = "I'm plain";
    l2->Title()    = "I'm raised";
    l3->Title()    = "I'm recessed";
    l4->Title()    = "I'm embossed";

}

void AppWindow::Initialize ()
{
    UI_DisplaySurface& sfc = CreateDisplaySurface();
}


void AppWindow::Finalize ()
{
    DestroyDisplaySurface();
}


    
int UI_Application::Main (int, char* [])
{
    AppWindow* root = new AppWindow;
    root->Background (UIColor_LightGray);
    MakeTopWindow (root);
    UI_Label::SetDefaultTextStyle (UIText_Center);

    root->Title()  = "YACL 3D Labels";
    root->Font() = UI_FontDesc (UIFont_Helvetica, 10);

    Run();
    return 0;
}

