

// This is a simple bitmap demo program using YACL. It illustrates how the
// application can put together a bitmap without using any resources, and
// have it displayed.
//
// M. A. Sridhar
// August 3, 1995

#include "ui/composit.h"
#include "ui/bitmap.h"
#include "ui/dsplsurf.h"
#include "ui/applic.h"


// ======================== Class AppWindow ===========================

class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();
    ~AppWindow ();
    
    // Override the Composite's virtual method:
    void Initialize ();

    bool Paint (const UI_Rectangle&);

protected:
    UI_BitmapData _bmpData;
    UI_Bitmap     _bitmap;
};

UI_BitmapData::ColorInfo colors[256] = {
{000, 180, 000},
{230, 230, 230},
{000, 000, 255},
{255,   0,   0},
{0, 0, 0}
};

ulong pixels [] = {
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 2,  2, 2, 2, 2, 2,  2, 2, 2, 2, 2,  2, 1, 1, 1, 1,  1, 1, 1, 1, 1,
                                                                               
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  2, 2, 2, 2, 2,  1, 3, 3, 3, 3,  3, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  2, 2, 2, 2, 1,  1, 1, 3, 3, 3,  3, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  2, 2, 2, 1, 1,  1, 1, 3, 3, 3,  3, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  2, 2, 1, 1, 1,  1, 1, 1, 3, 3,  3, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  2, 1, 1, 1, 1,  1, 1, 1, 1, 3,  3, 3, 3, 1, 1,
                                                                               
 1, 1, 1, 1, 1,  2, 2, 2, 2, 2,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  3, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 2, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 3, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 2, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 3, 1, 1,
 1, 1, 1, 1, 1,  2, 2, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  2, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
                                                                               
 1, 1, 1, 1, 1,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 0, 0,  0, 0, 0, 0, 0,  0, 0, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 0,  0, 0, 0, 0, 0,  0, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  0, 0, 0, 0, 0,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 0, 0, 0, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 0, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
 1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1

};
AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (40, 40, 100, 100)),
  _bmpData (25, 25, UI_BitmapData::Color_8Bits, 5, colors, pixels)
{
    _title = "YACL Bitmap Demo";
}


void AppWindow::Initialize ()
{
    CreateDisplaySurface ();
    _bitmap.BuildFrom (_bmpData);
}

bool AppWindow::Paint (const UI_Rectangle&)
{
    _displaySurface->ColorRectangle (_displaySurface->DrawingArea(),
                                     UIColor_White);
    _bitmap.DrawOn (*_displaySurface, UI_Point (38, 38));
    return FALSE; // Return FALSE, as a rule, so that event dependents (if
                  // any) can be notified
}



AppWindow::~AppWindow ()
{
    DestroyDisplaySurface ();
}




// ========================== Main program ==========================


int UI_Application::Main (int, char* [])
{
    MakeTopWindow (new AppWindow);
    Run();
    return 0;
}


