


#include "ui/orbtngrp.h"
#include "ui/xrbtngrp.h"
#include "ui/pushbtn.h"
#include "ui/label.h"
#include "ui/stred.h"
#include "ui/dialog.h"
#include "ui/applic.h"
#include "ui/font.h"

#include "appwin.h"
#include "ids.h"

UI_ViewDescriptor desc[] = {
    {View_PushButton, ID_START, 0, 0,  60, 30, TRUE, "Start"},
    {View_PushButton, ID_QUIT,  0, 60, 60, 30, TRUE, "Quit"},
    {View_None, -1, 0, 0, 0, 0, 0, 0}
};


UI_DialogEventDescriptor desc2 [] = {
    ID_OK,     Event_Select,
    ID_CANCEL, Event_Select,
    -1,  Event_None
};




AppWindow::AppWindow ()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (50, 50, 500, 400))
{
    msg = new UI_Label (this, UI_Rectangle (10, 100, 340, 250));
//     msg->Font().PointSize(10);
    _title = "YACL Dialog Demo";
}




extern UI_ViewDescriptor  DLG_DIALOG_1_Item[];
extern UI_RectangleStruct DLG_DIALOG_1_Shape;


#if defined(__UNIX__) || defined(__OS2__)
#define END_OF_LINE "\n"
#else
#define END_OF_LINE "\r\n"
#endif


bool AppWindow::HandleChildEvent(const UI_Event& e)
{
    UI_CompositeVObject::HandleChildEvent (e);
    if( e.Origin()->ViewID() == ID_QUIT && e.Type()== Event_Select) {
        _Application->End();
        return FALSE;
    }
    if (e.Origin()->ViewID() != ID_START || e.Type() != Event_Select)
        return FALSE;


    UI_Dialog* d =  new UI_Dialog (this,  DLG_DIALOG_1_Item,
                                   DLG_DIALOG_1_Shape, desc2, ID_OK);
    d->Title() = "Inner dialog";
    UI_StringEditor* ed = (UI_StringEditor*) ((*d) [ID_FILENAME]);
    ed->SetLengthLimit (20);
    CL_String& stred_data = (CL_String &) ed->Model();
    stred_data = "Put <= 20 chars here";
    CL_String& msg_value = (CL_String &) (msg->Model());
    msg_value = "";

    UI_OrButtonGroup& grp = *CL_CAST_PTR (UI_OrButtonGroup*, (*d)[ID_PERMS]);
    grp[ID_READ]->Model() = CL_Integer (1);
    
    // Now execute the dialog modally
    UI_ViewID quitID = d->ExecuteModal ().id; 

    // Retrieve its contents
    CL_IntPtrMapIterator itr ((CL_IntPtrMap &) (d->Model()) );
    itr.Reset();
    while (itr.More()) {
        CL_IntPtrAssoc  assoc = itr.Next();
        UI_ViewID id = assoc.key;
        msg_value += "Id " + CL_String (id)
            + " value: " + assoc.value->AsString() + END_OF_LINE;
    }
    msg_value += "Quit button Id: " + CL_String (quitID)
        + END_OF_LINE;

    // Get rid of the dialog
    _Application->Destroy (d);
    return TRUE;
}

