
// A dialog with "duelling" StringViews
//
// M. A. Sridhar
// May 13, 1995

#include "ui/applic.h"
#include "ui/dialog.h"
#include "ui/font.h"
#include "ui/dsplsurf.h"

#include "evtproc.h"
#include "ids.h"

// ======================== Main program ===========================

UI_ViewDescriptor  DialogItem [] = {
{View_StringViewMulti,  ID_LEFT  ,   20,  26, 125, 165, TRUE, "", NULL},
{View_StringViewMulti,  ID_RIGHT ,  260,  26, 125, 165, TRUE, "", NULL},
{View_PushButton,       ID_L_TO_R,  185,  59,  60,  30, TRUE, "->", NULL},
{View_PushButton,       ID_R_TO_L,  185, 114,  60,  30, TRUE, "<-", NULL},
{View_PushButton,       ID_DONE  ,  178, 213,  70,  30, TRUE, "Done", NULL},
View_None, 0, 0
}; 




//  ------------------------ Testing -------------------------------
// class GridPainter {
// 
// public:
//     GridPainter (UI_CompositeVObject* comp);
//     bool Paint ();
// 
// protected:
//     UI_CompositeVObject* _comp;
// };
// 
// typedef UI_EventBinding0<GridPainter> Bind;
// 
// #if defined(__GNUC__)
// template class UI_EventBinding0<GridPainter>;
// #endif
// 
// GridPainter::GridPainter (UI_CompositeVObject* comp)
// : _comp (comp)
// {
//     _comp->AddEventDependent (Event_Paint,
//                               Bind (this, &GridPainter::Paint));
// }
// 
// bool GridPainter::Paint ()
// {
//     UI_DisplaySurface& sfc = _comp->CreateDisplaySurface();
//     sfc.Pen().Color (UIColor_Red);
//     UI_Rectangle r = sfc.DrawingArea ();
//     const short interval = 20;
//     long w = r.Width(), h = r.Height ();
//     for (long i = interval; i < w; i += interval)
//         sfc.DrawLine (UI_Point (i, 0), UI_Point (i, h));
//     for (i = interval; i < h; i += interval)
//         sfc.DrawLine (UI_Point (0, i), UI_Point (w, i));
//     _comp->DestroyDisplaySurface ();
// }

int UI_Application::Main (int, char* [])
{
    UI_Dialog* root = new UI_Dialog
        (NULL, DialogItem, UI_Rectangle (45, 40, 430, 260));
    root->Title() = "YACL Dual StringView Demo";
    MakeTopWindow (root);
    EventProcessor proc (*root);
    //  GridPainter paint (root);
    Run();
    return 0;
}


