

#include "ui/label.h"
#include "ui/stddlg.h"
#include "ui/numedit.h"
#include "ui/pswdedit.h"
#include "ui/dateedit.h"

#include "appwin.h"

enum {
    ID_NUMBER    = 101,
    ID_DATE      = 102,
    ID_PASSWORD  = 103,
    ID_NUMBERL   = 111,
    ID_DATEL     = 112,
    ID_PASSWORDL = 113
};
        

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, UI_Rectangle (30, 50, 300, 200))
{
    UI_Label* label1 = new UI_Label 
        (this, UI_Rectangle (15, 20, 150, 30), ID_NUMBERL);
    UI_Label* label2 = new UI_Label 
        (this, UI_Rectangle (15, 70, 150, 30), ID_DATEL);
    UI_Label* label3 = new UI_Label 
        (this, UI_Rectangle (15, 120, 150, 30), ID_PASSWORDL);
    label1->Title() = "Type a number:";
    label2->Title() = "Type a date:";
    label3->Title() = "Type a password:";
    new UI_NumberEditor   (this, UI_Rectangle (175, 20,  100, 30), ID_NUMBER);
    new UI_DateEditor     (this, UI_Rectangle (175, 70,  100, 30), ID_DATE);
    new UI_PasswordEditor (this, UI_Rectangle (175, 120, 100, 30),
                           ID_PASSWORD);
    Title()  = "YACL Editors Demo";
}

bool AppWindow::WantToQuit ()
{
    CL_String s;
    s += "Number: "   + ((CL_String&) (*this)[ID_NUMBER]  ->Model()) + "\n";
    s += "Date: "     + ((CL_String&) (*this)[ID_DATE]    ->Model()) + "\n";
    s += "Password: " + ((CL_String&) (*this)[ID_PASSWORD]->Model()) + "\n";
    UI_StandardDialog (s);
    return TRUE;
}
