

#include "ui/applic.h"
#include "ui/label.h"
#include "ui/strview.h"
#include "ui/strseq.h"


#include "appwin.h"

enum {
    ID_LIST   = 101,
    ID_LABEL  = 102
};

UI_ViewDescriptor desc [] = {
{View_Label,             ID_LABEL,    30, 20, 260,  25,  FALSE, ""},
{View_StringViewSingle,  ID_LIST,     75, 60, 150, 200,  FALSE, ""},
{View_None, 0, 0}
};

AppWindow::AppWindow ()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (20, 50, 300, 300))
{
    Title () = "YACL Environment Demo";
    UI_Label& label = CL_CAST_REF (UI_Label&, *((*this)[ID_LABEL]));
    label.ShowBorder ();
    label.SetTextStyle (UIText_Left);

    UI_StringSequence& strSeq =
        CL_CAST_REF (UI_StringSequence&, ((*this)[ID_LIST]->Model()));
    const CL_StringStringMap& env = _Application->Environment ();
    CL_StringStringMapIterator itr (env);

    while (itr.More())
        strSeq.Add (itr.Next().key);
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    // The only Select event we'll get is from the StringView, so we don't
    // need to check its view id.
    UI_StringViewSingleSel& strView =
        *CL_CAST_PTR (UI_StringViewSingleSel*, (*this)[ID_LIST]);
    long select = strView.Selection ();
    UI_StringSequence& strseq =
        CL_CAST_REF (UI_StringSequence&, strView.Model());
    (*this)[ID_LABEL]->Model() = (_Application->Environment())
        [strseq[select]];
    return TRUE;
}

    
