

#ifndef _3dlabel_h_ /* Mon Dec 25 17:15:55 1995 */
#define _3dlabel_h_


// A 3DLabel is a label drawn with a 3-d look, either raised, recessde
// or embossed.
//
// The implementation of this object does not use a separate window,
// instead, it hooks paint events destined for its parent, and draws itself
// if necessary.

#include "ui/label.h"


class UI_DisplaySurface;
class UI_3DLabel: public UI_Label {

public:
    enum LabelStyle { Raised, Recessed, Embossed };
    
    UI_3DLabel (UI_VObjCollection* parent, 
                const UI_Rectangle& r, UI_ViewID id,
                LabelStyle style = Recessed);
    // Constructor: use this object's own model. The model will be
    // destroyed when this object is destroyed.

    UI_3DLabel (UI_VObjCollection* parent, CL_String* model,
                const UI_Rectangle& r, UI_ViewID id,
                LabelStyle style = Recessed);
    // Constructor: use the given string (second parameter) as model. The
    // model string is viewed as ``borrowed'', so it
    // is not this object's responsibility to destroy the model.

protected:
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    bool _PaintEvent (UI_Event&);

    void _DoPaint (UI_DisplaySurface&);

    bool _ModelChanged();

    LabelStyle _style;
};

#endif /* _3dlabel_h_ */
