

#include "ui/lineseg.h"
#include "ui/piewedge.h"
#include "ui/chord.h"
#include "ui/arc.h"
#include "ui/ellipse.h"
#include "ui/dsplsurf.h"
#include "ui/font.h"
#include "ui/shadorec.h"
#include "ui/shadotrg.h"

#include "appwin.h"


AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 625, 400))
{
    Title () = "YACL graphics demo 2";
}


bool AppWindow::Paint (const UI_Rectangle& invalidRect)
{
    Draw ();
    return TRUE;
}


static void _DrawGrid (UI_DrawingSurface& sfc, short gridSize = 40)
{
    UI_Rectangle area = sfc.DrawingArea ();
    UI_Pen& pen = sfc.Pen ();
    pen.Pattern (UIPen_Dot);
    long w = area.Width(), h = area.Height();
    long i;
    // Draw the vertical lines
    for (i = 0; i < w; i += gridSize)
        sfc.DrawLine (UI_Point (i, 0), UI_Point (i, h-1));
    // Draw the horizontal lines
    for (i = 0; i < h; i += gridSize)
        sfc.DrawLine (UI_Point (0, i), UI_Point (w-1, i));
}

static void _DrawTriangle (UI_DrawingSurface& sfc,
                           UI_ShadowedTriangle::Direction d,
                           UI_ReliefStyle r, const UI_Rectangle& shape,
                           const UI_Color& base)
{
    UI_ShadowedTriangle t (shape, d, r, base);
    t.DrawOn (sfc, UI_Point (0, 0));
}


static void DrawPolygons (UI_DrawingSurface& sfc, const UI_Vector& v)
{
    sfc.Brush().Color (UI_Color (0.0, 1.0, 1.0));
    sfc.Pen().Color (UIColor_Black);
    UI_Point polygon[4];
    polygon[0] = UI_Point (5,15) + v;
    polygon[1] = UI_Point (25,0) + v;
    polygon[2] = UI_Point (45,15) + v;
    polygon[3] = UI_Point (25,30) + v;
    sfc.DrawPolygon (polygon, 4);

    polygon[0] += UI_Vector (50, 0);
    polygon[1] += UI_Vector (50, 0);
    polygon[2] += UI_Vector (50, 0);
    polygon[3] += UI_Vector (50, 0);
    sfc.DrawPolygon (polygon, 4, UID_Outline | UID_Fill);
    sfc.WriteString ("Two polygons", UI_Rectangle (0, 50, 100, 30) + v,
                     UIText_Center);
}


static void DrawTriangles (UI_DrawingSurface& sfc, const UI_Vector& v)
{
    UI_Color baseColor (0.0, 0.75, 0.75);
        // Caveat: This color might look quite ugly on some display drivers.
    sfc.ColorRectangle (UI_Rectangle (10, 20, 200, 250) + v, baseColor);

    sfc.WriteString ("Shadowed triangles",
                     UI_Rectangle (10, 5, 200, 30) + v, UIText_Center);
    _DrawTriangle (sfc, UI_ShadowedTriangle::North,
                   UIRelief_Raised, UI_Rectangle (90, 30, 40, 40) + v,
                   baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::West,
                   UIRelief_Raised, UI_Rectangle (20, 60, 40, 40) + v,
                   baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::South,
                   UIRelief_Raised, UI_Rectangle (90, 90, 40, 40) + v,
                   baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::East,
                   UIRelief_Raised, UI_Rectangle (150, 60, 40, 40) + v,
                   baseColor);

    _DrawTriangle (sfc, UI_ShadowedTriangle::North, UIRelief_Recessed,
                   UI_Rectangle (90, 150, 40, 40) + v,
                   baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::West, UIRelief_Recessed,
                   UI_Rectangle (20, 180, 40, 40) + v,
                   baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::South, UIRelief_Recessed,
                   UI_Rectangle (90, 210, 40, 40) + v, baseColor);
    _DrawTriangle (sfc, UI_ShadowedTriangle::East, UIRelief_Recessed,
                   UI_Rectangle (150, 180, 40, 40) + v,
                   baseColor);

}

void AppWindow::Draw ()
{
    Background (UIColor_White);
    CreateDisplaySurface ();

    UI_Rectangle r;
    UI_DisplaySurface& sfc = *(DisplaySurface());

    UI_Rectangle area = sfc.DrawingArea ();
    area.Origin (UI_Point (0, 0));
    sfc.ColorRectangle (area, UIColor_White);

    // _DrawGrid (sfc);

    UI_Pen& pen = sfc.Pen ();
    UI_Brush& brush = sfc.Brush();
    UI_Font& font = sfc.Font();

    brush.Color (UIColor_Blue); brush.Pattern (UIBrush_Solid);
    pen.Color (UIColor_Red);
    sfc.DrawEllipse   (UI_Rectangle (150, 20,  100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    pen.Thickness (1);
    pen.Color (UIColor_Black);
    pen.Pattern (UIPen_Dash);
    sfc.DrawLine (UI_Point (20,  35), UI_Point (80,  35));
    pen.Pattern (UIPen_Solid);
    sfc.DrawLine (UI_Point (20,  50), UI_Point (80,  50));

    font = UI_FontDesc (UIFont_Courier, 12, UIFont_Underline);
    sfc.WriteString ("An ellipse", UI_Rectangle (270, 20, 145, 30));

    brush.Color   (UI_Color (0.0, 1.0, 1.0)); // Cyan
    sfc.DrawRectangle (UI_Rectangle (150, 90, 100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Times,   12, UIFont_Italic | UIFont_BoldFace);
    sfc.WriteString ("A rectangle", UI_Rectangle (270, 100, 145, 40));


    pen.Thickness (2);
    pen.Color (UIColor_Green); 
    sfc.DrawLine (UI_Point (20,  90), UI_Point (80,  90));
    pen.Color (UIColor_Red);
    sfc.DrawLine (UI_Point (20, 110), UI_Point (80, 110));
    pen.Color (UIColor_Blue);
    sfc.DrawLine (UI_Point (20, 130), UI_Point (80, 130));

    pen.Color (UIColor_MediumGray);
    font = UI_FontDesc (UIFont_Helvetica, 12, UIFont_BoldFace);
    sfc.WriteString ("A few lines", UI_Rectangle (20, 150, 120, 40));

    font = UI_FontDesc (UIFont_Times, 12, UIFont_StrikeOut |
                        UIFont_BoldFace);
    sfc.WriteString ("Struck out text", UI_Rectangle (20, 200, 130, 40));

    pen.Thickness (1);

    brush.Color (UI_Color (UIColor_Green)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 180, 100, 60);
    UI_PieWedge p (r, 60*64, 100*64);
    sfc.DrawPieWedge (p, (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Courier, 12, UIFont_BoldFace | UIFont_Italic);
    sfc.WriteString ("A PieWedge", UI_Rectangle (250, 200, 145, 40));

    brush.Color   (UI_Color (UIColor_MediumGray)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 240, 100, 60);
    UI_Chord c (r, 60*64, 110*64);
    sfc.DrawChord (c, (UID_DrawOptions) (UID_Outline | UID_Fill));
    sfc.WriteString ("A Chord", UI_Rectangle (250, 250, 145, 40));

    r = UI_Rectangle (150, 300, 100, 60);
    UI_Arc arc (r, 60*64, 249*64);
    arc.DrawOn (sfc);
    sfc.WriteString ("An arc", UI_Rectangle (250, 320, 145, 40));

    sfc.ColorRectangle (UI_Rectangle (10, 240, 100, 140), UIColor_LightGray);
    font.PointSize (9);

    UI_ShadowRectangle sRec1 (20, 270, 80, 30,
                              UI_ShadowRectangle::Raised, 2);
    sRec1.DrawOn (sfc);

    UI_ShadowRectangle sRec2 (20, 330, 80, 30,
                              UI_ShadowRectangle::Recessed, 2);
    sRec2.DrawOn (sfc);

    font.Style (0); // No style  options
    pen.Color (UIColor_Black);
    sfc.WriteString ("Raised",   sRec1 + UI_Vector (0, 3), UIText_Center);
    sfc.WriteString ("Recessed", sRec2 + UI_Vector (0, 3), UIText_Center);

    DrawTriangles (sfc, UI_Vector (380, 0));

    DrawPolygons (sfc, UI_Vector (420, 300));
    DestroyDisplaySurface ();
}
