

#include "ui/lineseg.h"
#include "ui/piewedge.h"
#include "ui/chord.h"
#include "ui/arc.h"
#include "ui/ellipse.h"
#include "ui/dsplsurf.h"
#include "ui/font.h"
#include "ui/shadorec.h"
#include "ui/bitmap.h"
#include "ui/cntroler.h"

#include "appwin.h"


AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 425,
                                                        400))
{
    Title () = "YACL DwgSurfaceInMemory Demo";
    _bmp = NULL;
}


bool AppWindow::Paint (const UI_Rectangle& invalidRect)
{
    if (!_bmp) {
        _Controller->BeginWait();
        _Draw ();
        _Controller->EndWait();
    }
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    _bmp->DrawOn (sfc);
    DestroyDisplaySurface ();
    return TRUE;
}


static void _DrawGrid (UI_DrawingSurface& sfc, short gridSize = 40)
{
    UI_Rectangle area = sfc.DrawingArea ();
    UI_Pen& pen = sfc.Pen ();
    pen.Pattern (UIPen_Dot);
    long w = area.Width(), h = area.Height();
    long i;
    // Draw the vertical lines
    for (i = 0; i < w; i += gridSize)
        sfc.DrawLine (UI_Point (i, 0), UI_Point (i, h-1));
    // Draw the horizontal lines
    for (i = 0; i < h; i += gridSize)
        sfc.DrawLine (UI_Point (0, i), UI_Point (w-1, i));
}

void AppWindow::_Draw ()
{
    UI_DwgSurfaceInMemory sfc (_shape.Width(), _shape.Height());
    Background (UIColor_White);
    UI_Rectangle area = sfc.DrawingArea ();
    area.Origin (UI_Point (0, 0));
    sfc.ColorRectangle (area, UIColor_White);

    _DrawGrid (sfc);

    UI_Pen& pen = sfc.Pen ();
    UI_Brush& brush = sfc.Brush();
    UI_Font& font = sfc.Font();

    brush.Color (UIColor_Blue); brush.Pattern (UIBrush_Solid);
    pen.Color (UIColor_Red);
    sfc.DrawEllipse   (UI_Rectangle (150, 20,  100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    pen.Thickness (1);
    pen.Color (UIColor_Black);
    pen.Pattern (UIPen_Dash);
    sfc.DrawLine (UI_Point (20,  35), UI_Point (80,  35));
    pen.Pattern (UIPen_Solid);
    sfc.DrawLine (UI_Point (20,  50), UI_Point (80,  50));

    font = UI_FontDesc (UIFont_Courier, 12, UIFont_Underline);
    sfc.WriteString ("An ellipse", UI_Rectangle (270, 20, 145, 30));

    brush.Color   (UI_Color (0.0, 1.0, 1.0)); // Cyan
    sfc.DrawRectangle (UI_Rectangle (150, 90, 100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Helvetica, 11, UIFont_Italic | UIFont_BoldFace);
    sfc.WriteString ("A rectangle", UI_Rectangle (270, 100, 145, 40));

    UI_Bitmap bmp;
    if (bmp.BuildFrom ("undo.bmp"))
        bmp.DrawOn (sfc, UI_Point (270, 145));
    sfc.WriteString ("A bitmap", UI_Rectangle (310, 145, 145, 40));

    pen.Thickness (2);
    pen.Color (UIColor_Green); 
    sfc.DrawLine (UI_Point (20,  90), UI_Point (80,  90));
    pen.Color (UIColor_Red);
    sfc.DrawLine (UI_Point (20, 110), UI_Point (80, 110));
    pen.Color (UIColor_Blue);
    sfc.DrawLine (UI_Point (20, 130), UI_Point (80, 130));

    pen.Color (UIColor_MediumGray);
    font = UI_FontDesc (UIFont_Helvetica, 12, UIFont_BoldFace);
    sfc.WriteString ("A few lines", UI_Rectangle (20, 150, 120, 40));

    font = UI_FontDesc (UIFont_Times, 12, UIFont_StrikeOut |
                        UIFont_BoldFace);
    sfc.WriteString ("Struck out text", UI_Rectangle (20, 200, 130, 40));

    pen.Thickness (1);

    brush.Color (UI_Color (UIColor_Green)); 
    pen.Color   (UI_Color (UIColor_Red));
    UI_Rectangle r (150, 180, 100, 60);
    UI_PieWedge p (r, 60*64, 100*64);
    sfc.DrawPieWedge (p, (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Courier, 14, UIFont_BoldFace | UIFont_Italic);
    sfc.WriteString ("A PieWedge", UI_Rectangle (270, 200, 145, 40));

    brush.Color   (UI_Color (UIColor_MediumGray)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 240, 100, 60);
    UI_Chord c (r, 60*64, 110*64);
    sfc.DrawChord (c, (UID_DrawOptions) (UID_Outline | UID_Fill));
    sfc.WriteString ("A Chord", UI_Rectangle (270, 250, 145, 40));

    r = UI_Rectangle (150, 300, 100, 60);
    UI_Arc arc (r, 60*64, 249*64);
    arc.DrawOn (sfc);
    sfc.WriteString ("An arc", UI_Rectangle (270, 320, 145, 40));

    sfc.ColorRectangle (UI_Rectangle (10, 240, 100, 140), UIColor_LightGray);
    font.PointSize (9);

    UI_ShadowRectangle sRec1 (20, 270, 80, 30,
                              UI_ShadowRectangle::Raised, 2);
    sRec1.DrawOn (sfc);

    UI_ShadowRectangle sRec2 (20, 330, 80, 30,
                              UI_ShadowRectangle::Recessed, 2);
    sRec2.DrawOn (sfc);

    font.Style (0); // No style  options
    pen.Color (UIColor_Black);
    sfc.WriteString ("Raised",   sRec1 + UI_Vector (0, 3), UIText_Center);
    sfc.WriteString ("Recessed", sRec2 + UI_Vector (0, 3), UIText_Center);

    _bmp = new UI_Bitmap;
    _bmp->CopyFrom (sfc, UI_Rectangle (0, 0, _shape.Width(), _shape.Height()));
}
