
// --------------------------- appwin.cxx --------------------------------

#include "appwin.h"
#include "ui/stddlg.h"
#include "ui/applic.h"

enum {
    ID_BUTTON = 10
  , ID_LABEL  = 11
};

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, UI_Rectangle (40, 40, 400, 200))
{
    _count = 5;
    _msg   = new UI_Label (this, UI_Rectangle (55, 55, 245, 20), ID_LABEL);
    _btn   = new UI_PushButton (this, UI_Rectangle (75, 85, 225, 50),
                                ID_BUTTON);
    _msg->Title() = "Hello!";
    _btn->Title() = "Click here " + CL_String(_count) + " times.";
    Title()       = "YACL Demo";
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin()->ViewID() == ID_BUTTON && e.Type() == Event_Select) {
        _count--;
        if (_count == 0)
            _Application->Destroy (this);
        else
            _btn->Title () (11,1) =  CL_String(_count);
        return TRUE;
    }
    return FALSE;
}

bool AppWindow::WantToQuit()
{
    return (UI_StandardDialog ("Do you really want to quit?", "Confirm", NULL,
                               UIS_YesNo, UIS_Question) == UI_IDYES);
}
