


#include "ui/lineseg.h"
#include "ui/piewedge.h"
#include "ui/chord.h"
#include "ui/arc.h"
#include "ui/ellipse.h"
#include "ui/dsplsurf.h"
#include "ui/label.h"

#include "appwin.h"


AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 500, 300))
{
    Title() = "YACL hit-testing demo";
    _status = new UI_Label (this, UI_Rectangle (10, 10, 400, 30));
    _status->Title() = "Click anywhere";
    _graphics.Add (new UI_LineSegment (UI_Point (150, 50), 3.0, 70));
    _graphics.Add (new UI_Chord (UI_Rectangle (300, 80, 100, 200), 30*64,
                                 100*64));
    _graphics.Add (new UI_PieWedge (UI_Rectangle (150, 150, 100, 200), 30*64,
                                    120*64));
    _graphics.Add (new UI_Ellipse   (100, 50, UI_Point (70, 80)));
    _graphics.Add (new UI_Rectangle (200, 50, 40, 40));
}

AppWindow::~AppWindow()
{
    _graphics.DestroyContents();
}


void AppWindow::Initialize ()
{
    _bgColor = UIColor_White; 
}


bool AppWindow::Paint (const UI_Rectangle&)
{
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    short n = _graphics.Size();
    for (short i = 0; i < n; i++)
        ((UI_GraphicObject*) _graphics[i])->DrawOn (sfc, UI_Point(0,0));
    DestroyDisplaySurface ();
    return TRUE;
}


bool AppWindow::ButtonDown (const UI_Point& p, UI_MouseButton m,
                            bool, bool)
{
    if (m != UIM_Left)
        return FALSE;
    short n = _graphics.Size();
    UI_HitTest result;
    for (short i = 0; i < n; i++) {
        result = ((UI_GraphicObject*) _graphics[i])->HitTest (p);
        if (result != UIHit_Outside)
            break;
    }
    switch (result) {
    case UIHit_Boundary:
        _status->Title() = "On boundary of " +
            CL_String (_graphics[i]->ClassName());
        break;

    case UIHit_Inside:
        _status->Title() = "Inside " + CL_String (_graphics[i]->ClassName());
        break;
        
    case UIHit_Outside:
        _status->Title() = "Outside";
        break;
    }
    return TRUE;
}


