

// A sample MDI application using YACL

#include "ui/mdi.h"
#include "ui/applic.h"
#include "ui/label.h"
#include "ui/menu.h"

#include "ids.h"
#include "menudrv.h"


UI_MenuItemDescriptor FileMenu [] = {
    {"&New window"    , ID_NEW  ,  NULL     }
  , {"&Exit"          , ID_QUIT ,  NULL     }
  , {NULL             , 0       ,  NULL     }
};

UI_MenuItemDescriptor WindowMenu [] = {
    {"&Tile"          , ID_TILE ,  NULL     }
  , {"&Cascade"       , ID_CASC ,  NULL     }
  , {"&Arrange icons" , ID_ARR  ,  NULL     }
  , {NULL             , 0       ,  NULL     }
};

UI_MenuItemDescriptor MainMenuDesc [] = {   // Main menu bar
    {"&File"          , ID_FILE ,  FileMenu }
  , {"&Window"        , ID_WINDO,  WindowMenu}
  , {NULL             ,        0,  NULL    }
};



int UI_Application::Main (int, char* [])
{
    UI_MDIMainWindow* root = new UI_MDIMainWindow
        (UI_Rectangle (300, 75, 300, 200), MainMenuDesc, ID_WINDO);
    root->Title() = "YACL MDI Demo";
    MakeTopWindow (root);
    MenuDriver driver (root->MenuBar());
    Run();
    return 0;
}

