

#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/composit.h"

#include "menudrv.h"
#include "ids.h"

#ifdef __BORLANDC__
extern unsigned _stklen = 35000;
#endif

UI_MenuItemDescriptor App1Submenu [] = {
  {"A one",          ID_SUBMENU1}
, {"A two",          ID_SUBMENU2}
, {NULL,                       0}
};

UI_MenuItemDescriptor App1Menu [] = {
  {"&Jan",           ID_JAN,       NULL       }
, {"&Feb",           ID_FEB,       NULL       }
, {"&Mar",           ID_MAR,       App1Submenu}
, {UIMenu_Separator, NULL,         NULL       }
, {"&Apr",           ID_APR,       NULL       }
, {"Ma&y",           ID_MAY,       NULL       }
, {NULL,             0,            NULL       }
};

UI_MenuItemDescriptor App2Menu [] = {
    {"Monday",       ID_MON}
  , {"Tuesday",      ID_TUE}
  , {"Wednesday",    ID_WED}
  , {0,                   0}
};


UI_MenuItemDescriptor MainMenuDesc [] = {
    {"&One",        ID_APP1,   App1Menu}
  , {"&Two",        ID_APP2,   App2Menu}
  , {NULL  ,              0,   NULL    }
};


UI_ViewDescriptor vDesc [] = {
{View_ToggleButton,  501,      27, 33, 90, 26, TRUE ,  "Read", NULL},
{View_ToggleButton,  502,     27, 68, 90, 26, FALSE,  "Write", NULL},
{View_ToggleButton,  503,      27, 103, 90, 26, FALSE,  "Execute", NULL},
{View_None, 0, 0}
};



// ======================== Main program ===========================


int UI_Application::Main (int, char* [])
{
    UI_CompositeVObject* root = new UI_CompositeVObject
        (NULL, NULL, FALSE, UI_Rectangle (100, 100, 250, 250));
    MakeTopWindow (root);
    root->Title() = "Parent window";
    UI_MenuBar*     mainMenu =  new UI_MenuBar (root, MainMenuDesc);
    MenuDriver driver;
    driver.Setup (mainMenu);

    UI_CompositeVObject* child = new UI_CompositeVObject
        (root, vDesc, FALSE, UI_Rectangle (200, 200, 250, 250));
    child->Title() = "Child window";
    UI_MenuBar* childMenu =  new UI_MenuBar (child, MainMenuDesc);
    MenuDriver childDriver;
    childDriver.Setup (childMenu);
    Run();
    return 0;
}

