
#include <iostream.h>
#include "ids.h"
#include "appwin.h"

#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "ui/label.h"
#include "ui/menu.h"


#define ID_ADD    101
#define ID_REMOVE 102



UI_MenuItemDescriptor App1Submenu [] = {
  {"One",       ID_SUBMENU1, NULL}
, {"Two",       ID_SUBMENU2, NULL}
, {NULL,        0,           NULL}
};

UI_MenuItemDescriptor App1Menu [] = {
  {"&Jan",      ID_JAN,    NULL}
, {"&Feb",      ID_FEB,    NULL}
, {"&Mar",      ID_MAR,    App1Submenu}
, {"---",       NULL,      NULL} // Separator
, {"&Apr",      ID_APR,    NULL}
, {"Ma&y",      ID_MAY,    NULL}
, {NULL,        0,         NULL}
};

UI_MenuItemDescriptor App2Menu [] = {
    {"Monday",      ID_MON,  NULL}
  , {"Tuesday",     ID_TUE,  NULL}
  , {"Wednesday",   ID_WED,  NULL}
  , {0,             0,   NULL}
};


UI_MenuItemDescriptor MainMenuDesc [] = {
    {"&One",   ID_APP1, App1Menu}
  , {"&Two",   ID_APP2, App2Menu}
  , {NULL,     0, NULL}
};


UI_MenuItemDescriptor PopupMenuDesc [] = {
    {"&Add",    ID_ADD,    NULL}
  , {"&Remove", ID_REMOVE, NULL}
  , {NULL,      0,         NULL}
};


typedef UI_EventBinding2<AppWindow> AppBind;

#if defined(__GNUC__)
template class UI_EventBinding2<AppWindow>;
#endif

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (100, 100, 350, 200))
{
    Title() = "YACL Popup Menu Demo";
    
    UI_MenuBar*     mainMenu =  new UI_MenuBar (this, MainMenuDesc);
    _driver.Setup (mainMenu);

    _popupMenu = new UI_PopupMenu (this, PopupMenuDesc);
    AppBind bind1 (this, &AppWindow::Selected, ID_ADD);
    (*_popupMenu)[ID_ADD]->AddEventDependent (Event_Select, bind1);
    AppBind bind2 (this, &AppWindow::Selected, ID_REMOVE);
    (*_popupMenu)[ID_REMOVE]->AddEventDependent (Event_Select, bind2);
    UI_Label* lbl = new UI_Label (this, UI_Rectangle (5, 35, 290, 30));
    lbl->Title() = "Right mouse btn gives popup menu";
}


bool AppWindow::Selected (UI_Event&, long id)
{
    UI_StandardDialog (CL_String ("Selected: ") + CL_String (id));
    return TRUE;
}


bool AppWindow::ButtonDown (const UI_Point& curPos, UI_MouseButton btn,
                            bool, bool)
{
    if (btn == UIM_Right || btn == UIM_Middle)
        _popupMenu->ShowAt (curPos);
    return FALSE;
}

bool AppWindow::Reconfigure (const UI_Rectangle& /* shape */ )
{
//    cout << "Reconfigure to " << shape << endl;
    return FALSE;
}

