

#include "menudrv.h"
#include "ids.h"


#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"



#if defined(__GNUC__)
template class UI_EventBinding2 <MenuDriver>; // Instantiate the binding
#endif

typedef UI_EventBinding2 <MenuDriver> MenuBinding;

struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
} FAR dispatch [] = {
    {ID_JAN,      MenuDriver::Inform, Event_Select}
  , {ID_FEB,      MenuDriver::Inform, Event_Select}
  , {ID_MAR,      MenuDriver::Inform, Event_Select}
  , {ID_APR,      MenuDriver::Inform, Event_Select}
  , {ID_MAY,      MenuDriver::Inform, Event_Select}
};



void MenuDriver::Setup (UI_Menu* menu)
{
    _menu = menu;
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        UI_ViewID id = dispatch[i].menu_id;
        (*menu)[id]->AddEventDependent
            (dispatch[i].event, MenuBinding (this, dispatch[i].method, id));
    }
}




bool MenuDriver::Inform (UI_Event&, long id)
{
    CL_String s = (*_menu)[id]->Title();
    s.Replace ("&", "");
    UI_StandardDialog ("You chose " + s);
    return TRUE;
}





