

#include "menudrv.h"
#include "ids.h"

#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "ui/strview.h"
#include "ui/dialog.h"

typedef UI_EventBinding2 <MenuDriver> MenuBinding;
#if defined(__GNUC__)
template class UI_EventBinding1 <MenuDriver>; // Instantiate the binding
template class UI_EventBinding2 <MenuDriver>; // Instantiate the binding
#endif


#define DIALOG_RESOURCE "DIALOG_1"
#define MENU_RESOURCE   "MENU_1"

struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
} FAR dispatch [] = {
      {ID_JAN,      MenuDriver::Inform}      
    , {ID_FEB,      MenuDriver::Inform}      
    , {ID_MAR,      MenuDriver::Inform}      
    , {ID_APR,      MenuDriver::Inform}      
                                                                          
    , {ID_ADD,      MenuDriver::Add}           
    , {ID_REMOVE,   MenuDriver::Remove}           
    , {ID_MONTH,    MenuDriver::DisableMonth} 
    , {ID_DAY,      MenuDriver::DisableDays}   
    , {ID_DIALOG,   MenuDriver::Dialog}   
    , {ID_QUIT,     MenuDriver::Quit}
};




MenuDriver::MenuDriver (UI_CompositeVObject* root)
{
    _menu =  new UI_MenuBar (root, MENU_RESOURCE);
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        UI_ViewID id = dispatch[i].menu_id;
        MenuBinding bind (this, dispatch[i].method, id);
        (*_menu)[id]->AddEventDependent (Event_Select, bind);
    }
    (*_menu)[ID_REMOVE]->Disable();
    _daysEnabled = TRUE;
}




bool MenuDriver::Inform (UI_Event&, UI_ViewID itemID)
{
    CL_String s = (*_menu)[itemID]->Title();
    s.Replace ("&", "");
    UI_StandardDialog ("You chose '" + s + "'", "YACL Resource Demo");
    return TRUE;
}


bool MenuDriver::Add (UI_Event&, UI_ViewID)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // Need this ifdef because we cannot  associate view id's with
    // non-leaf menu items in resource-based menus under Windows
    UI_ViewID monthMenuId = (_menu->Child (_menu->RootID(), 1))->ViewID();
#else
    UI_ViewID monthMenuId = ID_MONTH_MENU;
#endif
    _menu->Add (ID_MAY, "Ma&y", monthMenuId);
    (*_menu)[ID_ADD]->Disable();
    (*_menu)[ID_REMOVE]->Enable();
    UI_StandardDialog ("Added an item to Month menu", "YACL Resource Demo");
    return TRUE;
}


bool MenuDriver::Remove (UI_Event&, UI_ViewID)
{
    _menu->Remove (ID_MAY);
    (*_menu)[ID_REMOVE]->Disable();
    (*_menu)[ID_ADD]->Enable();
    UI_StandardDialog ("Removed an item from Month menu",
                       "YACL Resource Demo"); 
    return TRUE;
}



bool MenuDriver::DisableMonth (UI_Event&, UI_ViewID)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewID monthMenuId = (_menu->Child (_menu->RootID(), 1))->ViewID();
#else
    UI_ViewID monthMenuId = ID_MONTH_MENU;
#endif
    UI_MenuItem* m = (*_menu)[monthMenuId];
    m->ToggleEnabledState();
    if (m->IsEnabled())
        m->Title() = "&Month";
    else
        m->Title() = "No month";
    return TRUE;
}


bool MenuDriver::DisableDays  (UI_Event&, UI_ViewID)
{
    (*_menu)[ID_MON]->ToggleEnabledState();
    (*_menu)[ID_TUE]->ToggleEnabledState();
    (*_menu)[ID_WED]->ToggleEnabledState();
    (*_menu)[ID_THU]->ToggleEnabledState();
    (*_menu)[ID_FRI]->ToggleEnabledState();
    char* msg = _daysEnabled ? " disabled" : " enabled";
    UI_StandardDialog (CL_String ("All days ") + msg, "YACL Resource Demo");
    _daysEnabled = _daysEnabled ? FALSE : TRUE;
    return TRUE;
}


bool MenuDriver::Quit (UI_Event&, UI_ViewID)
{
    YACLApp()->End();
    return TRUE;
}



const char* data[] = {
    "Onions",
    "Tomatoes",
    "Black olives",
    "Green olives",
    "Jalapenos",
    "Pineapples",
    "Green peppers",
    "Banana peppers",
    "Spinach",
    "Green olives",
    "Extra sauce",
    0
};



bool MenuDriver::Dialog (UI_Event&, UI_ViewID)
{
    UI_Dialog* dlg = new UI_Dialog (YACLApp()->MainWindow(),
                                    DIALOG_RESOURCE);
    UI_StringViewSingleSel* lbox, *rbox;
    lbox = (UI_StringViewSingleSel*) (*dlg)[ID_LEFT];
    UI_StringSequence& seq = (UI_StringSequence&) lbox->Model();
    for (short i = 0; data[i] != 0; i++)
        seq.Add (data[i]);
    UI_EventBinding1 <MenuDriver> bind (this, &MenuDriver::DialogEvt);
    dlg->AddEventDependent (Event_Select, bind);
    (*dlg)[ID_R_TO_L]->Disable();
    dlg->ExecuteModal ();
    YACLApp()->Destroy (dlg);
    return TRUE;
}



static long Move (UI_StringViewMultiSel* from, UI_StringViewMultiSel* to)
{
    CL_IntegerSet s = from->Selection ();
    UI_StringSequence& fromSeq = (UI_StringSequence&) from->Model();
    UI_StringSequence& toSeq   = (UI_StringSequence&) to  ->Model();
    fromSeq.Move (s, toSeq);
    return fromSeq.Size();
}

bool  MenuDriver::DialogEvt (UI_Event& e)
{
    if (e.Type() != Event_Select)
        return TRUE;  // NEVER return FALSE from an event-dependent method.
                      // If you do, other event dependents might not get
                      // notified!! 
    UI_ViewID id = e.Origin()->ViewID();
    if (id != ID_L_TO_R && id != ID_R_TO_L)
        return TRUE;
    UI_Dialog* dlg = (UI_Dialog*) e.Destination();
    UI_StringViewMultiSel* lbox = (UI_StringViewMultiSel*) (*dlg)[ID_LEFT];
    UI_StringViewMultiSel* rbox = (UI_StringViewMultiSel*) (*dlg)[ID_RIGHT];
    if (id == ID_L_TO_R)
        Move (lbox, rbox);
    else
        Move (rbox, lbox);
    long lSize = ((UI_StringSequence&) lbox->Model()).Size();
    long rSize = ((UI_StringSequence&) rbox->Model()).Size();
    (*dlg)[ID_L_TO_R]->SetEnabledState (lSize > 0);
    (*dlg)[ID_R_TO_L]->SetEnabledState (rSize > 0);
    return TRUE;
}
