
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/label.h"
#include "ui/font.h"
#include "ui/3dlabel.h"
#include "ui/toglbtn.h"

#include "appwin.h"

#include <iostream.h> // DEBUG
const char* MESSAGE = "Status bar";
enum {
    LABEL_ID = 101,
    SCROLLWINDOW_ID,
    SHOW_HORZ,
    SHOW_VERT
        
};
const StatusBarHeight = 35;


#if defined(__X_MOTIF__) // Too bad I need this platform-dependent ifdef: X
                         // fonts don't correspond well with Windows and
                         // OS/2 fonts.
static const int FontSize = 10;
#else
static const int FontSize = 9;
#endif

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 500, 300))
{
    Title() = "YACL Scrollable Window Demo";
    long yBottom = Shape().Height() - StatusBarHeight;
    _status = new UI_3DLabel (this, UI_Rectangle (0, yBottom,
                                                  500, StatusBarHeight),
                              LABEL_ID, UI_3DLabel::Embossed);
    _win = new UI_ScrollableWindow (this,
                                    UI_Rectangle (0, 0, 500, yBottom),
                                    SCROLLWINDOW_ID);
    _status->Title() = MESSAGE;
    _status->SetTextStyle (UIText_Center);
    _status->Font() = UI_FontDesc (UIFont_Helvetica, FontSize);
    (new UI_ToggleButton (_win, UI_Rectangle (20, 30, 150, 30),
                          SHOW_HORZ))->Title() = "Hide horizontal";
    (new UI_ToggleButton (_win, UI_Rectangle (20, 70, 150, 30),
                          SHOW_VERT))->Title() = "Hide vertical";
    
}

AppWindow::~AppWindow()
{
}



bool AppWindow::Reconfigure (const UI_Rectangle& rect)
{
    long yBottom = rect.Height() - StatusBarHeight;
    UI_Rectangle winShape (0, 0, rect.Width(), yBottom);
    _win->Shape() = winShape;
    _status->Shape() = UI_Rectangle (0, yBottom, rect.Width(),
                                     StatusBarHeight);
    _status->Title() = "ScrollableWindow shape " + _win->Shape().AsString();
    return FALSE;
}




bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    UI_ViewID id = e.Origin()->ViewID();
    UI_EventType type = e.Type();
    if (id == SHOW_HORZ && type == Event_Select)
        _win->HorzScrollBar().ToggleVisibility();
    else if (id == SHOW_VERT && type == Event_Select)
        _win->VertScrollBar().ToggleVisibility();
    else if (type >= Event_Scroll && type <= Event_ScrollToPosition) {
        _status->Title() = "Scroll models: horz "
            + _win->HorzScrollBar().Model().AsString()
            + " vert "
            + _win->VertScrollBar().Model().AsString();
    }
    return FALSE;
}






