
// A dialog with "duelling" StringViews
//
// M. A. Sridhar
// May 13, 1995

#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/strseq.h"
#include "ui/textedit.h"


// ======================== Main program ===========================



UI_RectangleStruct Dialog_shape = {
//---- YACLDlgEditorBegin Dialog shape ------
    40, 40, 481, 475
//---- YACLDlgEditorEnd Dialog shape ------
};

enum {
    ID_STRVIEW = 101,
    ID_COMBO,
    ID_STRED,
    ID_LABEL1,
    ID_LABEL2,
    ID_LABEL3,
    ID_TOGGLE,
    ID_XRTGL,
    ID_TEXTED
};

UI_ViewDescriptor Dialog_dlgDesc [] = {
//---- YACLDlgEditorBegin Dialog items ------
{View_Label          , ID_LABEL1   , 15, 13,  125,   30, FALSE, "StringView:"},
{View_StringViewSingle, ID_STRVIEW,  30, 45,  280,  90, TRUE, ""},
{View_Label          , ID_LABEL2   , 20,  143,  125,   30, FALSE, "ComboBox:"},
{View_ComboBox       , ID_COMBO    , 30, 175, 280,   75, TRUE, ""},
{View_Label          , ID_LABEL3   , 24,224,  125, 30, FALSE, "StringEditor:"},
{View_StringEditor   , ID_STRED    ,  165,  223,  125,   30, TRUE, ""},
{View_TextView       , ID_TEXTED   ,   20,  255,  400,  150, TRUE, ""},
// {View_PushButton     , 56          ,  138,  275, 75,   30, TRUE, "Ok"},
// {View_PushButton     , 57          ,  261,  274, 75,   30, TRUE, "Cancel"},
{View_ToggleButton   , ID_TOGGLE   ,  320,   49, 126, 30, TRUE, "Toggle"},
{View_ExOrToggleButton,ID_XRTGL     , 320,   91, 126, 30, TRUE, "ExOr Toggle"},
{View_None, 0, 0}
//---- YACLDlgEditorEnd Dialog items ------
};





char* Data [] = {
    "A study in scarlet",
    "The sign of four",
    "The valley of fear",
    "The hound of the Baskervilles",
    "The speckled band",
    "The \"Gloria Scott\"",
    "The Musgrave ritual",
    "The resident patient",
    "The Greek interpreter",
    NULL
};


char* Message = "This app shows how to set VisualObject colors.";

int UI_Application::Main (int, char* [])
{
    UI_CompositeVObject* root = new UI_CompositeVObject
        (NULL, Dialog_dlgDesc, FALSE, Dialog_shape);
    root->Title() = "YACL VisualObject Colors Demo";
    MakeTopWindow (root);

    root->Background (UIColor_LightGray);
    (*root)[ID_LABEL1]->Background (UIColor_LightGray);
    (*root)[ID_LABEL2]->Background (UIColor_LightGray);
    (*root)[ID_LABEL3]->Background (UIColor_LightGray);
    (*root)[ID_TOGGLE]->Background (UIColor_LightGray);
    (*root)[ID_XRTGL]->Background (UIColor_LightGray);
    (*root)[ID_COMBO]->Background (UIColor_LightGray);
    (*root)[ID_STRED]->Background (UIColor_MediumGray);
    (*root)[ID_STRVIEW]->Background (UIColor_LightGray);

    UI_TextEditor* edit = (UI_TextEditor*) (*root)[ID_TEXTED];
    edit->Background (UIColor_DarkGray);
    edit->Foreground (UIColor_White);
    ((CL_String&) edit->Model()) = Message;

    (*root)[ID_LABEL1]->Foreground (UIColor_Red);
    (*root)[ID_LABEL2]->Foreground (UIColor_Green);
    (*root)[ID_LABEL3]->Foreground (UIColor_Blue);

    UI_StringSequence& comboSq = (UI_StringSequence&)
        ((*root)[ID_COMBO]->Model());
    UI_StringSequence& listSq = (UI_StringSequence&)
        ((*root)[ID_STRVIEW]->Model());
    short i;
    for (i = 0; Data[i] != NULL; i++) {
        comboSq.Add (Data[i]);
        listSq.Add (Data[i]);
    }

    Run();
    return 0;
}


