/*********************************************************************
 *                                                                   *
 * MODULE NAME :  drgfiles.h             AUTHOR:  Rick Fishman       *
 * DATE WRITTEN:  07-28-93                                           *
 *                                                                   *
 * DESCRIPTION:                                                      *
 *                                                                   *
 *  Common definitions and function prototypes for DRGFILES.EXE      *
 *                                                                   *
 * HISTORY:                                                          *
 *                                                                   *
 *  07-28-93 - Coding started.                                       *
 *                                                                   *
 *  Rick Fishman                                                     *
 *  Code Blazers, Inc.                                               *
 *  4113 Apricot                                                     *
 *  Irvine, CA. 92720                                                *
 *  CIS ID: 72251,750                                                *
 *                                                                   *
 *********************************************************************/

/*********************************************************************/
/*------------------- APPLICATION DEFINITIONS -----------------------*/
/*********************************************************************/

#define DEBUG_FILENAME         "drgfiles.dbg"

#define DRGFILES_ICON_FILENAME "drgfiles.ico"

#ifndef CRA_SOURCE             // As of 09/03/93, CRA_SOURCE not in toolkit hdrs
#  define CRA_SOURCE           0x00004000L
#endif

/*********************************************************************/
/*----------------------- WINDOW DEFINITIONS ------------------------*/
/*********************************************************************/

#define ID_RESOURCES           10

#define IDM_EXIT               100

#define BASE_TEMPFILE_NAME     "TEMP"

/*********************************************************************/
/*-------------------------- HELPER MACROS --------------------------*/
/*********************************************************************/

#define ANCHOR(hwnd)   (WinQueryAnchorBlock( hwnd ))
#define HWNDERR(hwnd)  (ERRORIDERROR(WinGetLastError( ANCHOR( hwnd ))))
#define HABERR(hab)    (ERRORIDERROR(WinGetLastError( hab )))
#define PARENT(hwnd)   (WinQueryWindow( hwnd, QW_PARENT ))

/**********************************************************************/
/*---------------------------- STRUCTURES ----------------------------*/
/**********************************************************************/

typedef struct _CNRREC                            // CONTAINER RECORD STRUCTURE
{
  MINIRECORDCORE mrc;
  char           szFileName[ CCHMAXPATH ];        // File that icon represents
  char           szFullFileName[ CCHMAXPATH ];    // Same as above,path included

} CNRREC, *PCNRREC;

#define EXTRA_BYTES (sizeof( CNRREC ) - sizeof( MINIRECORDCORE ))

/**********************************************************************/
/*----------------------- FUNCTION PROTOTYPES ------------------------*/
/**********************************************************************/

// In drgfiles.c

void    Msg      ( PSZ szFormat, ... );
MRESULT DragError( USHORT usError, USHORT usOperation, HSTR hstrFile );

// In srcwin.c

HWND srcCreateWindow( HAB hab );

// In trgwin.c

HWND targCreateWindow( HAB hab );

/**********************************************************************/
/*------------------------ GLOBAL VARIABLES --------------------------*/
/**********************************************************************/

#ifdef GLOBALS_DEFINED
#   define DATADEF
#else
#   define DATADEF extern
#endif

DATADEF char szCurrentPath[ CCHMAXPATH ]; // Current path where pgm was loaded
DATADEF char szTempDir[ CCHMAXPATH ];     // Directory used for temporary files

DATADEF HPOINTER hptrCnrRec;     // Icon used in the containers

DATADEF HWND hwndDrag;           // Window that can drag and drop
DATADEF HWND hwndDrop;           // Window that can only drop initially

/***************************************************************************
 *                         E N D   O F   S O U R C E                       *
 ***************************************************************************/
