/*------------------------------------------------------------------------
         FILE HEADER FOR client.cpp
         HEADER LAST UPDATED : August 29, 1995
         PURPOSE :
              This is the entire program for the client side of
         pipesrv.cpp.  Both pipesrv.cpp and this program are tired together
         by constants defined in const.h.
              This program compiles either as a DOS program or an OS/2
         program using Borland C++ or Borland C++ for OS/2.

   ------------------------------------------------------------------*/


#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <string.h>
#include <dos.h>
#include "const.h"



typedef struct
        {
        short usCmd;
        char acData[_MIN_PIPE_BUFFER];
        } PIPEDATA;


void Help();
int ClientInit();
int ClientSystem(int iHandle);
int ClientWrite(int iHandle);
int ClientRead(int iHandle);
int ClientTransact(int iHandle,unsigned short usCmd,char *pszData,
                   PIPEDATA *pPipeData);

void main(int argc,char *argv[])
{
if (argc != 3 && argc != 2) Help();
if (*argv[1] != '-') Help();

int iHandle = ClientInit();
strupr(argv[1]);
switch (*(argv[1]+1))
       {
       case 'W':
            if (argc != 3)
               {
               printf("No string specified.\n");
               exit(1);
               }
            ClientWrite(iHandle);
            break;
       case 'R':
            ClientRead(iHandle);
            break;
       case 'C':
            if (argc != 3)
               {
               printf("No command specified for execution by server.\n");
               exit(1);
               }
            ClientSystem(iHandle);
            break;
       default:
           printf("Illegal first argument %s\n",argv[1]);
           exit(1);
       }

close(iHandle);
}

int SendCommand(int iHandle,unsigned short usCmd,char *pszData)
{
PIPEDATA PipeData;
size_t cb, cbWrite;
PipeData.usCmd = usCmd;
strcpy(PipeData.acData,pszData);
cb = sizeof(PipeData.usCmd)+strlen(pszData)+1;
if ((cbWrite = write(iHandle,&PipeData,cb)) != cb)
   {
   if ((int)cbWrite == -1)
      {
      perror("write");
      return FALSE;
      }
   printf("Write failed. Bytes expected = %d\nBytesWritten = %d",cb,cbWrite);
   return FALSE;
   }

return TRUE;
}

int ReadResults(int iHandle,PIPEDATA *pPipeData)
{
size_t cbRead;
cbRead = read(iHandle,pPipeData,sizeof(PIPEDATA));
if ((int)cbRead == -1)
   {
   perror("read");
   return FALSE;
   }
return TRUE;
}

int ClientTransact(int iHandle,unsigned short usCmd,char *pszData,
                   PIPEDATA *pPipeData)
{
if (!SendCommand(iHandle,usCmd,pszData)) return FALSE;
if (!ReadResults(iHandle,pPipeData)) return FALSE;
printf("Transaction complete.\n");
return TRUE;
}


int ClientWrite(int iHandle)
{
PIPEDATA PipeData;
if (!ClientTransact(iHandle,CMD_WRITE,_argv[2],&PipeData))
   {
   printf("The data could not be written to the server.\n");
   return FALSE;
   }
printf("The data was stored in the server.\n");
return TRUE;
}

int ClientRead(int iHandle)
{
PIPEDATA PipeData;
if (!ClientTransact(iHandle,CMD_READ,"xxxxxxxxxxxxxxxx",&PipeData))
   {
   printf("Read server data failed.\n");
   return FALSE;
   }
printf("The following data was read : %s\n",PipeData.acData);
return TRUE;
}

int ClientSystem(int iHandle)
{
PIPEDATA PipeData;
if (!ClientTransact(iHandle,CMD_SYSTEM,_argv[2],&PipeData))
   {
   printf("The request to execute the system() function failed.");
   return FALSE;
   }
printf("Errno from the system() function is %d\n",
       *(int *)PipeData.acData);
return TRUE;
}

void Help()
{
printf("Specify function, string. Functions are as follows.\n"
" -w  Write (store) string\n"
" -r  Read string written with -w\n"
" -c  Execute command via system() function in C standard library.\n"
"     Note that the system function will execute the string via the\n"
"     command processor, and that the server will not continue operation\n",
"     until the command is complete."
);

exit(0);
}

int ClientInit()
{
int iHandle;
iHandle = open("\\pipe\\test",O_RDWR | O_BINARY);
if (iHandle == -1)
   {
   perror("Error opening pipe");
   exit(1);
   }
PIPEDATA PipeData;
read(iHandle,&PipeData,sizeof(PIPEDATA));
if (PipeData.usCmd != RESPONSE_STARTED)
   {
   printf("Invalid initial response from pipe.\n");
   printf("Command : %d \n",PipeData.usCmd);
   printf("Data    : %s \n",PipeData.acData);
   exit(1);
   }

return iHandle;
}


