/* */

extern const char WC_Scroll[];

typedef struct _scroll {
    ULONG           records;		// number of records
    ULONG           width;		// width (characters) of max record
    HWND            hwndFrame;
    HWND            hwndClient;
    PVOID           user;
    char           *(*func) (long recnum, void *user);	// call back function
    int             xClient;		/* current width of client window */
    int             yClient;		/* current hieght of client window */
    int             xChar;		/* Max char width, in pixels. */
    int             yChar;		/* Max char hieght, in pixels. */
    int             yDesc;		/* lower case descender. Text at (0,0)
					 * will cut off descenders, whereas
					 * text at (0, yDesc) will not. */
    int             rows;		/* Number of full text lines, based on
					 * the current font, that will fit in
					 * the window. Usefull for deciding
					 * how big a 'page' is when PgUp/PgDn
					 * etc are used */
    int             cols;		/* as above */

    int             vScrollMax;		/* slider range    */
    int             hScrollMax;
    int             vScrollInc;		/* If non-zero, paint in progress was
					 * caused by a scrollbar. This has the
					 * number of rows (negative if upward
					 * scroll) scrolled */
    int             hScrollInc;		/* Scrooled cols. This one caused by a
					 * horizontal scroll bar. Neg for left
					 * scroll */
    int             vScrollPos;		/* line that sb in the top left of the
					 * client window (absolute vert scroll
					 * rows) */
    int             hScrollPos;		/* absolute horz offset */
    FONTMETRICS     fm;
}               SCROLL;

void            ScrollRegister(HAB hab, ULONG flStyle);
BOOL            vScrollParms(SCROLL * scrl, ULONG rec, ULONG maxrec);
BOOL            hScrollParms(SCROLL * scrl, ULONG pos, ULONG maxlen);

int             ClientScrollSetup( HWND hwndFrame,
                                   ULONG records,
                                   ULONG width,
                                   char *(*func) (long recnum, void *user),
                                   PVOID user);
