
#include "pmterm.h"

/*
 * pmterm.c -- main() and main window proc
 */

static PFNWP pfnOld;


extern char *format(long recnum, void *user);   // see src\thread2.c

MRESULT EXPENTRY MyWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    SCROLL *scrl = WinQueryWindowPtr(hwnd, 0);
    PDATA *pdata;
    USHORT c;
    ULONG bw;

    switch (msg) {
	case WM_CHAR:
            pdata = scrl->user;
            if(pdata){
                if(CHARMSG(&msg)->fs & KC_CHAR){
                    c = CHARMSG(&msg)->chr;
                    DosWrite(pdata->hf, &c, 1, &bw);
                }
                else if(CHARMSG(&msg)->fs & KC_VIRTUALKEY){
                    if(CHARMSG(&msg)->vkey == VK_ESC){
                        c = 27;
                        DosWrite(pdata->hf, &c, 1, &bw);
                    }
                }
            }
	    break;
        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)){
                case IDMI_SETTINGS:
                    Settings(scrl->user);
                    break;
                case IDMI_ABOUT:
                    pdata = scrl->user;
                    WinDlgBox(HWND_DESKTOP, pdata->hwndClient, WinDefDlgProc, 0, DLG_ABOUT, NULL);
                    break;
                case IDMI_EXIT:
                    WinPostMsg(hwnd, WM_QUIT, 0, 0);
                    break;
            }
            break;
	default:
            return pfnOld(hwnd, msg, mp1, mp2);
    }
    return 0;
}

int main(int argc, char **argv)
{
    HAB hab;
    HMQ hmq;
    HWND hwndFrame;
    QMSG qmsg;
    FRAMECDATA fcdata;
    PDATA *pdata;
    HINI hini;
    ULONG cb;

    if (!(hab = WinInitialize(0)))
	return 1;

    if (!(hmq = WinCreateMsgQueue(hab, 0)))
	return 1;


    /* Create frame window */
    fcdata.cb = sizeof(FRAMECDATA);
    fcdata.flCreateFlags = FCF_SHELLPOSITION | FCF_SIZEBORDER |
        FCF_TASKLIST | FCF_MINMAX | FCF_MENU | FCF_ACCELTABLE |
        FCF_SYSMENU | FCF_TITLEBAR | FCF_VERTSCROLL | FCF_HORZSCROLL;


    fcdata.hmodResources = 0;               /* Resource file not in DLL. */
    fcdata.idResources   = 1;

    hwndFrame = WinCreateWindow(
        HWND_DESKTOP,                   /* parent       */
        WC_FRAME,                       /* class */
        NULL,                           /* window text or data  */
        0,
        0, 0, 0, 0,                     /* Position and size       */
        (HWND)0,                           /* No owner                */
        HWND_TOP,                       /* On top of siblings      */
        fcdata.idResources,             /* Frame window identifier */
        &fcdata,                        /* Control data            */
        NULL);                          /* Reserved field          */

    if (!hwndFrame)
	return 1;			/* couldn't create window for some
					 * reason. */

    pdata = calloc(sizeof(PDATA), 1);

    hini = PrfOpenProfile(hab, "pmterm.ini");
    if(!hini){
        ErrMesg(pdata, "Couldn't open ini file 'PMTERM.INI'");
        exit(1);
    }

    cb = sizeof(INI_STUFF);
    if(!PrfQueryProfileData(hini, "pmterm", "settings", &pdata->ini, &cb) || cb != sizeof(INI_STUFF)){
        strcpy(pdata->ini.DevName, "COM2");
        strcpy(pdata->ini.InitString, "ATZ");
        pdata->ini.bps      = 19200;
        pdata->ini.parity   = 0;        // none
        pdata->ini.databits = 8;        // 8
        pdata->ini.stopbits = 0;        // 1
        pdata->ini.CtsRts   = TRUE;
        pdata->ini.XonXoff  = FALSE;
        pdata->ini.ExtBuf   = TRUE;
    }
    PrfCloseProfile(hini);

    ClientScrollSetup(hwndFrame, MAXLINES, MAXLINELEN, format, pdata);
    pdata->hab        = hab;
    pdata->hwndFrame  = hwndFrame;
    pdata->hwndClient = WinWindowFromID(hwndFrame, FID_CLIENT);
    pfnOld = WinSubclassWindow( pdata->hwndClient, MyWindowProc);
    WinShowWindow(hwndFrame, TRUE);
    SetupPort(pdata);

    while (WinGetMsg(hab, &qmsg, 0L, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    return 0;
}

