/*******************************************************************************
* FILE NAME: Bitmaps.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Bitmaps- Sample program showing bitmaps useage                           *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _IICONCTL_
#include <iiconctl.hpp>
#endif

#ifndef _IGRAPHBT_
#include <igraphbt.hpp>
#endif

#ifndef _IANIMBUT_
#include <ianimbut.hpp>
#endif

#ifndef _ISPINNUM_
#include <ispinnum.hpp>
#endif

#ifndef _ITBAR_
#include <itbar.hpp>
#endif

#ifndef _ITBARBUT_
#include <itbarbut.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _BITMAPS_
#include "Bitmaps.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for BitmapsConn0
//*****************************************************************************
class BitmapsConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~BitmapsConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton(buttonClickEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   IFrameWindow * target;


};   //BitmapsConn0


//*****************************************************************************
// Class definition for BitmapsConn1
//*****************************************************************************
class BitmapsConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~BitmapsConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Bitmaps * aSource, IAnimatedButton * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Bitmaps::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to AnimatedButton1(startAnimation))");
         try {target->startAnimation();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Bitmaps * source;
   IAnimatedButton * target;


};   //BitmapsConn1


//*****************************************************************************
// Class definition for BitmapsConn2
//*****************************************************************************
class BitmapsConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~BitmapsConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IGraphicPushButton * aSource, IAnimatedButton * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IGraphicPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : GraphicPushButton1(buttonClickEvent) to AnimatedButton1(stopAnimation))");
         try {target->stopAnimation();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IGraphicPushButton * source;
   IAnimatedButton * target;


};   //BitmapsConn2


//*****************************************************************************
// Class definition for BitmapsConn3
//*****************************************************************************
class BitmapsConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~BitmapsConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(INumericSpinButton * aSource, IAnimatedButton * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == INumericSpinButton::valueId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : NumericSpinButton1(value) to AnimatedButton1(animationRate))");
         try {target->setAnimationRate(source->value());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   INumericSpinButton * source;
   IAnimatedButton * target;


};   //BitmapsConn3


//*****************************************************************************
// Class definition for BitmapsConn4
//*****************************************************************************
class BitmapsConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~BitmapsConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IAnimatedButton * aSource, IAnimatedButton * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IAnimatedButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : AnimatedButton1(buttonClickEvent) to AnimatedButton1(startAnimation))");
         try {target->startAnimation();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IAnimatedButton * source;
   IAnimatedButton * target;


};   //BitmapsConn4


#pragma export (Bitmaps::readyId)
const INotificationId Bitmaps::readyId = "Bitmaps::readyId";

#pragma export (Bitmaps::partWindowId)
unsigned long Bitmaps::partWindowId = 0;

//------------------------------------------------------------------------------
// Bitmaps :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Bitmaps::defaultFramingSpec())
const IRectangle Bitmaps::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 33 - 535),ISize(612, 535)));
}


//------------------------------------------------------------------------------
// Bitmaps :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Bitmaps::defaultTitle())
IString Bitmaps::defaultTitle()
{
   return("Tels' bitmaps example");
}


//------------------------------------------------------------------------------
// Bitmaps :: Bitmaps
//------------------------------------------------------------------------------
#pragma export (Bitmaps::Bitmaps(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Bitmaps::Bitmaps(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(9,432),ISize(225, 27)));
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_Bitmaps_BitmapControl1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10001), 
      IRectangle(IPoint(343,123),ISize(64, 64)));
   iStaticText2 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(349,195),ISize(158, 27)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(30,141),ISize(310, 27)));
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText4, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(134,82),ISize(283, 27)));
   iIconControl1 = new IIconControl(
      partWindowId+WNDOFFSET_Bitmaps_IconControl1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10003), 
      IRectangle(IPoint(375,390),ISize(40, 40)));
   iStaticText5 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText5, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(16,390),ISize(253, 27)));
   iGraphicPushButton1 = new IGraphicPushButton(
      partWindowId+WNDOFFSET_Bitmaps_GraphicPushButton1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10002), 
      IRectangle(IPoint(16,325),ISize(64, 64)));
   iStaticText6 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText6, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(374,430),ISize(137, 27)));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText7, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(413,141),ISize(55, 27)));
   iAnimatedButton1 = new IAnimatedButton(
      partWindowId+WNDOFFSET_Bitmaps_AnimatedButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(152,210),ISize(128, 128)));
   iStaticText8 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText8, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(153,351),ISize(279, 27)));
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText9, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(122,47),ISize(307, 27)));
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText10, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(143,16),ISize(264, 27)));
   iStaticText11 = new IStaticText(
      partWindowId+WNDOFFSET_Bitmaps_StaticText11, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(318,297),ISize(116, 27)));
   iNumericSpinButton1 = new INumericSpinButton(
      partWindowId+WNDOFFSET_Bitmaps_NumericSpinButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(349,258),ISize(129, 32)));
   iToolBar1 = new IToolBar(
      partWindowId+WNDOFFSET_Bitmaps_ToolBar1, 
      this);
   iToolBarButton = new IToolBarButton(
      partWindowId+WNDOFFSET_Bitmaps_ToolBarButton, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() | IControl::group);

   conn0 = new BitmapsConn0();
   conn1 = new BitmapsConn1();
   conn2 = new BitmapsConn2();
   conn3 = new BitmapsConn3();
   conn4 = new BitmapsConn4();

   this->setFocus();
   this->setClient(iCanvas);
   iStaticText1->setText("Toolbarbutton ID: 10000");
   iStaticText1->setForegroundColor(IColor(0, 0, 128));
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText2->setText("Bitmap ID: 10001");
   iStaticText3->setText("Visual Example #000  v1.1 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iIconControl1->setMinimumSize(ISize(40, 40));
   iStaticText5->setText("GraficPushButton ID: 10002");
   iGraphicPushButton1->setMinimumSize(ISize(64, 64));
   iStaticText6->setText("Icon ID: 10003");
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iAnimatedButton1->setMinimumSize(ISize(128, 128));
   iAnimatedButton1->setAnimationRate(10);
   iAnimatedButton1->setBitmaps(IResourceId(10004), 10);
   iStaticText8->setText("AnimButton ID's: 10004-10014");
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText10->setText("http://www.pobox.com/~tels");
   iStaticText11->setText("Frame Rate:");
   iNumericSpinButton1->setLimit(3);
   iNumericSpinButton1->setRange(IRange(1, 100));
   iNumericSpinButton1->setValue(3);
   iToolBar1->addAsLast(iToolBarButton, iToolBarButton->isGroup());
   iToolBarButton->setBitmap(IResourceId(10000));
}     //end constructor


//------------------------------------------------------------------------------
// Bitmaps :: ~Bitmaps
//------------------------------------------------------------------------------
#pragma export (Bitmaps::~Bitmaps())
Bitmaps::~Bitmaps()
{
   conn0->stopHandlingNotificationsFor(*iToolBarButton);
   conn1->stopHandlingNotificationsFor(*this);
   conn2->stopHandlingNotificationsFor(*iGraphicPushButton1);
   conn3->stopHandlingNotificationsFor(*iNumericSpinButton1);
   conn4->stopHandlingNotificationsFor(*iAnimatedButton1);

   delete conn0;
   delete conn1;
   delete conn2;
   delete conn3;
   delete conn4;


   delete iCanvas;
   delete iStaticText1;
   delete iBitmapControl1;
   delete iStaticText2;
   delete iStaticText3;
   delete iStaticText4;
   delete iIconControl1;
   delete iStaticText5;
   delete iGraphicPushButton1;
   delete iStaticText6;
   delete iStaticText7;
   delete iAnimatedButton1;
   delete iStaticText8;
   delete iStaticText9;
   delete iStaticText10;
   delete iStaticText11;
   delete iNumericSpinButton1;
   delete iToolBar1;
   delete iToolBarButton;
}

//------------------------------------------------------------------------------
// Bitmaps :: initializePart
//------------------------------------------------------------------------------
#pragma export (Bitmaps::initializePart())
Bitmaps & Bitmaps::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Bitmaps :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Bitmaps::makeConnections())
Boolean Bitmaps::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iStaticText1->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText2->enableNotification();
   iStaticText3->enableNotification();
   iStaticText4->enableNotification();
   iIconControl1->enableNotification();
   iStaticText5->enableNotification();
   iGraphicPushButton1->enableNotification();
   iStaticText6->enableNotification();
   iStaticText7->enableNotification();
   iAnimatedButton1->enableNotification();
   iStaticText8->enableNotification();
   iStaticText9->enableNotification();
   iStaticText10->enableNotification();
   iStaticText11->enableNotification();
   iNumericSpinButton1->enableNotification();
   iToolBar1->enableNotification();
   iToolBarButton->enableNotification();

   conn0->initialize(iToolBarButton, this);
   conn0->handleNotificationsFor(*iToolBarButton);
   conn1->initialize(this, iAnimatedButton1);
   conn1->handleNotificationsFor(*this);
   conn2->initialize(iGraphicPushButton1, iAnimatedButton1);
   conn2->handleNotificationsFor(*iGraphicPushButton1);
   conn3->initialize(iNumericSpinButton1, iAnimatedButton1);
   conn3->handleNotificationsFor(*iNumericSpinButton1);
   conn4->initialize(iAnimatedButton1, iAnimatedButton1);
   conn4->handleNotificationsFor(*iAnimatedButton1);

   return true;
}



