/*******************************************************************************
* FILE NAME: dmain.cpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     dmain- Main Dummy App to test the EditWindow                             *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _EDITWIN_
#include "EditWin.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _DMAIN_
#include "dmain.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for dmainConn0
//*****************************************************************************
class dmainConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, dmainEditWinFacFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to EditWinFac(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   dmainEditWinFacFactory * target;


};   //dmainConn0


//*****************************************************************************
// Class definition for dmainConn1
//*****************************************************************************
class dmainConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(dmainEditWinFacFactory * aSource, IVBVariablePartPointer<EditWin *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == dmainEditWinFacFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EditWinFac(newEvent) to EditWindow(this))");
         try {target->setTarget((EditWin *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   dmainEditWinFacFactory * source;
   IVBVariablePartPointer<EditWin *> * target;


};   //dmainConn1


//*****************************************************************************
// Class definition for dmainConn2
//*****************************************************************************
class dmainConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(dmainEditWinFacFactory * aSource, IVBVariablePartPointer<EditWin *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target->target()) return(*this);
      if (anEvent.notificationId() == dmainEditWinFacFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EditWinFac(newEvent) to EditWindow(showModally))");
         try {target->target()->showModally();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   dmainEditWinFacFactory * source;
   IVBVariablePartPointer<EditWin *> * target;


};   //dmainConn2


//*****************************************************************************
// Class definition for dmainConn3
//*****************************************************************************
class dmainConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(dmainEditWinFacFactory * aSource, IVBVariablePartPointer<EditWin *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target->target()) return(*this);
      if (anEvent.notificationId() == dmainEditWinFacFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EditWinFac(newEvent) to EditWindow(setFocus))");
         try {target->target()->setFocus();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   dmainEditWinFacFactory * source;
   IVBVariablePartPointer<EditWin *> * target;


};   //dmainConn3


//*****************************************************************************
// Class definition for dmainConn4
//*****************************************************************************
class dmainConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IFrameWindow * target;


};   //dmainConn4


//*****************************************************************************
// Class definition for dmainConn5
//*****************************************************************************
class dmainConn5 : public IObserver, public IStandardNotifier {
public:
   virtual  ~dmainConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IVBVariablePartPointer<EditWin *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to EditWindow(deleteTarget))");
         try {target->deleteTarget();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IVBVariablePartPointer<EditWin *> * target;


};   //dmainConn5


const INotificationId dmainEditWinFacFactory::newObjectCreatedId = "dmainEditWinFacFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// dmainEditWinFacFactory :: dmainEditWinFacFactory
//------------------------------------------------------------------------------
#pragma export (dmainEditWinFacFactory::dmainEditWinFacFactory(unsigned long))
dmainEditWinFacFactory::dmainEditWinFacFactory(unsigned long anId)
{
   enableNotification();
   partWindowId = anId;
}

//------------------------------------------------------------------------------
// dmainEditWinFacFactory :: ~dmainEditWinFacFactory
//------------------------------------------------------------------------------
#pragma export (dmainEditWinFacFactory::~dmainEditWinFacFactory())
dmainEditWinFacFactory::~dmainEditWinFacFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// dmainEditWinFacFactory :: create
//------------------------------------------------------------------------------
#pragma export (dmainEditWinFacFactory::create())
EditWin * dmainEditWinFacFactory::create()
{
   EditWin *iEditWinFac = new EditWin(
      partWindowId+WNDOFFSET_dmain_EditWinFac, 
      IWindow::desktopWindow(), 
      0, 
      EditWin::defaultFramingSpec());
   iEditWinFac->setAutoDeleteObject(true);
   iEditWinFac->enableNotification();
   iEditWinFac->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iEditWinFac)));
   return(iEditWinFac);
}

#pragma export (dmain::readyId)
const INotificationId dmain::readyId = "dmain::readyId";

#pragma export (dmain::partWindowId)
unsigned long dmain::partWindowId = 0;

//------------------------------------------------------------------------------
// dmain :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (dmain::defaultFramingSpec())
const IRectangle dmain::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 343),ISize(572, 343)));
}


//------------------------------------------------------------------------------
// dmain :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (dmain::defaultTitle())
IString dmain::defaultTitle()
{
   return("Tels' Example EditWindow");
}


//------------------------------------------------------------------------------
// dmain :: dmain
//------------------------------------------------------------------------------
#pragma export (dmain::dmain(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
dmain::dmain(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_dmain_PushButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(315,234),ISize(189, 36)));
   iPushButton2 = new IPushButton(
      partWindowId+WNDOFFSET_dmain_PushButton2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(63,234),ISize(189, 36)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_dmain_StaticText3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(47,141),ISize(308, 27)));
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_dmain_BitmapControl1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10001), 
      IRectangle(IPoint(357,123),ISize(64, 64)));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_dmain_StaticText7, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(426,142),ISize(55, 27)));
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_dmain_StaticText4, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(131,81),ISize(283, 27)));
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_dmain_StaticText9, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(119,46),ISize(307, 27)));
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_dmain_StaticText10, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(141,15),ISize(264, 27)));
   iEditWinFac = new dmainEditWinFacFactory(partWindowId);
   iEditWindow = new IVBVariablePartPointer<EditWin *>();

   conn0 = new dmainConn0();
   conn1 = new dmainConn1();
   conn2 = new dmainConn2();
   conn3 = new dmainConn3();
   conn4 = new dmainConn4();
   conn5 = new dmainConn5();

   this->setFocus();
   this->setClient(iCanvas);
   iPushButton1->setText("Open Edit Window");
   iPushButton2->setText("Exit");
   iStaticText3->setText("Visual Example #001  v2.0 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText10->setText("http://www.pobox.com/~tels");
}     //end constructor


//------------------------------------------------------------------------------
// dmain :: ~dmain
//------------------------------------------------------------------------------
#pragma export (dmain::~dmain())
dmain::~dmain()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*iEditWinFac);
   conn2->stopHandlingNotificationsFor(*iEditWinFac);
   conn3->stopHandlingNotificationsFor(*iEditWinFac);
   conn4->stopHandlingNotificationsFor(*iPushButton2);
   conn5->stopHandlingNotificationsFor(*iPushButton2);

   delete conn0;
   delete conn1;
   delete conn2;
   delete conn3;
   delete conn4;
   delete conn5;


   delete iCanvas;
   delete iPushButton1;
   delete iPushButton2;
   delete iStaticText3;
   delete iBitmapControl1;
   delete iStaticText7;
   delete iStaticText4;
   delete iStaticText9;
   delete iStaticText10;
   delete iEditWinFac;
   delete iEditWindow;
}

//------------------------------------------------------------------------------
// dmain :: initializePart
//------------------------------------------------------------------------------
#pragma export (dmain::initializePart())
dmain & dmain::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// dmain :: makeConnections
//------------------------------------------------------------------------------
#pragma export (dmain::makeConnections())
Boolean dmain::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iPushButton1->enableNotification();
   iPushButton2->enableNotification();
   iStaticText3->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText7->enableNotification();
   iStaticText4->enableNotification();
   iStaticText9->enableNotification();
   iStaticText10->enableNotification();
   iEditWinFac->enableNotification();
   iEditWindow->enableNotification();

   conn0->initialize(iPushButton1, iEditWinFac);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(iEditWinFac, iEditWindow);
   conn1->handleNotificationsFor(*iEditWinFac);
   conn2->initialize(iEditWinFac, iEditWindow);
   conn2->handleNotificationsFor(*iEditWinFac);
   conn3->initialize(iEditWinFac, iEditWindow);
   conn3->handleNotificationsFor(*iEditWinFac);
   conn4->initialize(iPushButton2, this);
   conn4->handleNotificationsFor(*iPushButton2);
   conn5->initialize(iPushButton2, iEditWindow);
   conn5->handleNotificationsFor(*iPushButton2);

   return true;
}



