/*******************************************************************************
* FILE NAME: Connect.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Connect- Connect two Inputlines                                          *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _IGROUPBX_
#include <igroupbx.hpp>
#endif

#ifndef _ISTRING_
#include <istring.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _CONNECT_
#include "Connect.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for ConnectConn0
//*****************************************************************************
class ConnectConn0 : public IObserver {
public:
   virtual  ~ConnectConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, IVBVariableClass<IString> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField1(text) to IString(this))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setText(target->target());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField1(text) to IString(this))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTarget(source->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IVBVariableClass<IString>::targetId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   IVBVariableClass<IString> * target;
   Boolean aligning;


};   //ConnectConn0


//*****************************************************************************
// Class definition for ConnectConn1
//*****************************************************************************
class ConnectConn1 : public IObserver {
public:
   virtual  ~ConnectConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariableClass<IString> * aSource, IStaticText * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : IString(this) to StaticText1(text))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setTarget(target->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : IString(this) to StaticText1(text))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setText(source->target());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBVariableClass<IString>::targetId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IStaticText::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariableClass<IString> * source;
   IStaticText * target;
   Boolean aligning;


};   //ConnectConn1


//*****************************************************************************
// Class definition for ConnectConn2
//*****************************************************************************
class ConnectConn2 : public IObserver {
public:
   virtual  ~ConnectConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariableClass<IString> * aSource, IEntryField * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : IString(this) to EntryField2(text))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setTarget(target->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : IString(this) to EntryField2(text))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setText(source->target());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBVariableClass<IString>::targetId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IEntryField::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariableClass<IString> * source;
   IEntryField * target;
   Boolean aligning;


};   //ConnectConn2


#pragma export (Connect::readyId)
const INotificationId Connect::readyId = "Connect::readyId";

#pragma export (Connect::partWindowId)
unsigned long Connect::partWindowId = 0;

//------------------------------------------------------------------------------
// Connect :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Connect::defaultFramingSpec())
const IRectangle Connect::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 541),ISize(574, 541)));
}


//------------------------------------------------------------------------------
// Connect :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Connect::defaultTitle())
IString Connect::defaultTitle()
{
   return("Tels' connect inputlines example");
}


//------------------------------------------------------------------------------
// Connect :: Connect
//------------------------------------------------------------------------------
#pragma export (Connect::Connect(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Connect::Connect(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText10, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(159,26),ISize(264, 27)));
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText9, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(138,57),ISize(307, 27)));
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText4, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(150,92),ISize(283, 27)));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText7, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(429,151),ISize(55, 27)));
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_Connect_BitmapControl1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10001), 
      IRectangle(IPoint(357,133),ISize(64, 64)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(46,151),ISize(310, 27)));
   iEntryField1 = new IEntryField(
      partWindowId+WNDOFFSET_Connect_EntryField1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(177,439),ISize(318, 27)));
   iEntryField2 = new IEntryField(
      partWindowId+WNDOFFSET_Connect_EntryField2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(184,287),ISize(318, 27)), 
      IEntryField::defaultStyle() | IEntryField::readOnly);
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(184,321),ISize(108, 27)));
   iStaticText2 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(36,321),ISize(121, 27)));
   iStaticText5 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText5, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(36,287),ISize(94, 27)));
   iStaticText6 = new IStaticText(
      partWindowId+WNDOFFSET_Connect_StaticText6, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(29,439),ISize(102, 27)));
   iGroupBox1 = new IGroupBox(
      partWindowId+WNDOFFSET_Connect_GroupBox1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(14,263),ISize(532, 120)));
   iIString = new IVBVariableClass<IString>();

   conn0 = new ConnectConn0();
   conn1 = new ConnectConn1();
   conn2 = new ConnectConn2();

   this->setFocus();
   this->setClient(iCanvas);
   iStaticText10->setText("http://www.pobox.com/~tels");
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText3->setText("Visual Example #002  v1.0 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iEntryField1->setLimit(40);
   iEntryField2->setLimit(40);
   iStaticText1->setText("StaticText1");
   iStaticText1->setForegroundColor(IColor(IColor::red));
   iStaticText2->setText("\"Static\" text:");
   iStaticText2->setForegroundColor(IColor(IColor::black));
   iStaticText5->setText("Readonly:");
   iStaticText5->setForegroundColor(IColor(IColor::black));
   iStaticText6->setText("Enter text:");
   iGroupBox1->setText("You typed");
}     //end constructor


//------------------------------------------------------------------------------
// Connect :: ~Connect
//------------------------------------------------------------------------------
#pragma export (Connect::~Connect())
Connect::~Connect()
{
   conn0->stopHandlingNotificationsFor(*iEntryField1);
   conn0->stopHandlingNotificationsFor(*iIString);
   conn1->stopHandlingNotificationsFor(*iIString);
   conn1->stopHandlingNotificationsFor(*iStaticText1);
   conn2->stopHandlingNotificationsFor(*iIString);
   conn2->stopHandlingNotificationsFor(*iEntryField2);

   delete conn0;
   delete conn1;
   delete conn2;


   delete iCanvas;
   delete iStaticText10;
   delete iStaticText9;
   delete iStaticText4;
   delete iStaticText7;
   delete iBitmapControl1;
   delete iStaticText3;
   delete iEntryField1;
   delete iEntryField2;
   delete iStaticText1;
   delete iStaticText2;
   delete iStaticText5;
   delete iStaticText6;
   delete iGroupBox1;
   delete iIString;
}

//------------------------------------------------------------------------------
// Connect :: initializePart
//------------------------------------------------------------------------------
#pragma export (Connect::initializePart())
Connect & Connect::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Connect :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Connect::makeConnections())
Boolean Connect::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iStaticText10->enableNotification();
   iStaticText9->enableNotification();
   iStaticText4->enableNotification();
   iStaticText7->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText3->enableNotification();
   iEntryField1->enableNotification();
   iEntryField2->enableNotification();
   iStaticText1->enableNotification();
   iStaticText2->enableNotification();
   iStaticText5->enableNotification();
   iStaticText6->enableNotification();
   iGroupBox1->enableNotification();
   iIString->enableNotification();

   conn0->initialize(iEntryField1, iIString);
   conn0->handleNotificationsFor(*iEntryField1);
   conn0->handleNotificationsFor(*iIString);
   conn1->initialize(iIString, iStaticText1);
   conn1->handleNotificationsFor(*iIString);
   conn1->handleNotificationsFor(*iStaticText1);
   conn2->initialize(iIString, iEntryField2);
   conn2->handleNotificationsFor(*iIString);
   conn2->handleNotificationsFor(*iEntryField2);

   conn0->setTarget();
   conn1->setTarget();
   conn2->setTarget();
   return true;
}



