/*******************************************************************************
* FILE NAME: Cnverter.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Converter- Converter Window                                              *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _CONVERTERCORE_
#include "convcore.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _CONVERTER_
#include "Cnverter.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for ConverterConn0
//*****************************************************************************
class ConverterConn0 : public IObserver {
public:
   virtual  ~ConverterConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, ConverterCore * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField1(text) to ConverterCore(tempx))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setText(target->tempx());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField1(text) to ConverterCore(tempx))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTempx(source->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == ConverterCore::tempxId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   ConverterCore * target;
   Boolean aligning;


};   //ConverterConn0


//*****************************************************************************
// Class definition for ConverterConn1
//*****************************************************************************
class ConverterConn1 : public IObserver {
public:
   virtual  ~ConverterConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, ConverterCore * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField2(text) to ConverterCore(tempd))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setText(target->tempd());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField2(text) to ConverterCore(tempd))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTempd(source->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == ConverterCore::tempdId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   ConverterCore * target;
   Boolean aligning;


};   //ConverterConn1


//*****************************************************************************
// Class definition for ConverterConn2
//*****************************************************************************
class ConverterConn2 : public IObserver {
public:
   virtual  ~ConverterConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, ConverterCore * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField3(text) to ConverterCore(tempb))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setText(target->tempb());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField3(text) to ConverterCore(tempb))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTempb(source->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == ConverterCore::tempbId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   ConverterCore * target;
   Boolean aligning;


};   //ConverterConn2


//*****************************************************************************
// Class definition for ConverterConn3
//*****************************************************************************
class ConverterConn3 : public IObserver {
public:
   virtual  ~ConverterConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, ConverterCore * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField4(text) to ConverterCore(tempc))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setText(target->tempc());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EntryField4(text) to ConverterCore(tempc))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTempc(source->text());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == ConverterCore::tempcId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   ConverterCore * target;
   Boolean aligning;


};   //ConverterConn3


#pragma export (Converter::readyId)
const INotificationId Converter::readyId = "Converter::readyId";

#pragma export (Converter::partWindowId)
unsigned long Converter::partWindowId = 0;

//------------------------------------------------------------------------------
// Converter :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Converter::defaultFramingSpec())
const IRectangle Converter::defaultFramingSpec()
{
   return(IRectangle(IPoint(127, IWindow::desktopWindow()->size().height() - 224 - 207),ISize(570, 207)));
}


//------------------------------------------------------------------------------
// Converter :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (Converter::defaultStyle())
const IFrameWindow::Style Converter::defaultStyle()
{
   return(IFrameWindow::defaultStyle() & ~IFrameWindow::maximizeButton & ~IFrameWindow::minimizeButton & ~IFrameWindow::maximized & ~IFrameWindow::minimized | IWindow::saveBits | IWindow::synchPaint);
}


//------------------------------------------------------------------------------
// Converter :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Converter::defaultTitle())
IString Converter::defaultTitle()
{
   return("Converter");
}


//------------------------------------------------------------------------------
// Converter :: Converter
//------------------------------------------------------------------------------
#pragma export (Converter::Converter(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Converter::Converter(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iMultiCellCanvas1 = new IMultiCellCanvas(
      partWindowId+WNDOFFSET_Converter_MultiCellCanvas1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(13,14),ISize(540, 146)));
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_Converter_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iEntryField1 = new IEntryField(
      partWindowId+WNDOFFSET_Converter_EntryField1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_Converter_StaticText4, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_Converter_StaticText3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText2 = new IStaticText(
      partWindowId+WNDOFFSET_Converter_StaticText2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iEntryField2 = new IEntryField(
      partWindowId+WNDOFFSET_Converter_EntryField2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField3 = new IEntryField(
      partWindowId+WNDOFFSET_Converter_EntryField3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField4 = new IEntryField(
      partWindowId+WNDOFFSET_Converter_EntryField4, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField5 = new IEntryField(
      partWindowId+WNDOFFSET_Converter_EntryField5, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IEntryField::readOnly);
   iStaticText5 = new IStaticText(
      partWindowId+WNDOFFSET_Converter_StaticText5, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iConverterCore = new ConverterCore();

   conn0 = new ConverterConn0();
   conn1 = new ConverterConn1();
   conn2 = new ConverterConn2();
   conn3 = new ConverterConn3();

   this->setFocus();
   this->setClient(iCanvas);
   this->setAutoDeleteObject(true);
   iCanvas->setBackgroundColor(IColor(IColor::darkPink));
   iMultiCellCanvas1->addToCell(iStaticText1, 1, 1, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField1, 2, 1, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText4, 1, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText3, 1, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText2, 1, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField2, 2, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField3, 2, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField4, 2, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField5, 2, 5, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText5, 1, 5, 1, 1);
   iMultiCellCanvas1->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setRowHeight(6, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setText("Hex");
   iStaticText1->setForegroundColor(IColor(IColor::white));
   iEntryField1->setLimit(4096);
   iEntryField1->setMinimumSize(ISize(395, 26));
   iStaticText4->setText("ASCII");
   iStaticText4->setForegroundColor(IColor(IColor::white));
   iStaticText3->setText("Bin");
   iStaticText3->setForegroundColor(IColor(IColor::white));
   iStaticText2->setText("Dec");
   iStaticText2->setForegroundColor(IColor(IColor::white));
   iEntryField2->setLimit(4096);
   iEntryField3->setLimit(4096);
   iEntryField4->setLimit(4096);
   iEntryField4->setMinimumSize(ISize(475, 27));
   iEntryField5->setLimit(4096);
   iEntryField5->setText("Not ready yet.");
   iStaticText5->setText("Instr");
   iStaticText5->setForegroundColor(IColor(IColor::white));
}     //end constructor


//------------------------------------------------------------------------------
// Converter :: ~Converter
//------------------------------------------------------------------------------
#pragma export (Converter::~Converter())
Converter::~Converter()
{
   conn0->stopHandlingNotificationsFor(*iEntryField1);
   conn0->stopHandlingNotificationsFor(*iConverterCore);
   conn1->stopHandlingNotificationsFor(*iEntryField2);
   conn1->stopHandlingNotificationsFor(*iConverterCore);
   conn2->stopHandlingNotificationsFor(*iEntryField3);
   conn2->stopHandlingNotificationsFor(*iConverterCore);
   conn3->stopHandlingNotificationsFor(*iEntryField4);
   conn3->stopHandlingNotificationsFor(*iConverterCore);

   delete conn0;
   delete conn1;
   delete conn2;
   delete conn3;


   delete iCanvas;
   delete iMultiCellCanvas1;
   delete iStaticText1;
   delete iEntryField1;
   delete iStaticText4;
   delete iStaticText3;
   delete iStaticText2;
   delete iEntryField2;
   delete iEntryField3;
   delete iEntryField4;
   delete iEntryField5;
   delete iStaticText5;
   delete iConverterCore;
}

//------------------------------------------------------------------------------
// Converter :: initializePart
//------------------------------------------------------------------------------
#pragma export (Converter::initializePart())
Converter & Converter::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Converter :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Converter::makeConnections())
Boolean Converter::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iStaticText1->enableNotification();
   iEntryField1->enableNotification();
   iStaticText4->enableNotification();
   iStaticText3->enableNotification();
   iStaticText2->enableNotification();
   iEntryField2->enableNotification();
   iEntryField3->enableNotification();
   iEntryField4->enableNotification();
   iEntryField5->enableNotification();
   iStaticText5->enableNotification();
   iConverterCore->enableNotification();

   conn0->initialize(iEntryField1, iConverterCore);
   conn0->handleNotificationsFor(*iEntryField1);
   conn0->handleNotificationsFor(*iConverterCore);
   conn1->initialize(iEntryField2, iConverterCore);
   conn1->handleNotificationsFor(*iEntryField2);
   conn1->handleNotificationsFor(*iConverterCore);
   conn2->initialize(iEntryField3, iConverterCore);
   conn2->handleNotificationsFor(*iEntryField3);
   conn2->handleNotificationsFor(*iConverterCore);
   conn3->initialize(iEntryField4, iConverterCore);
   conn3->handleNotificationsFor(*iEntryField4);
   conn3->handleNotificationsFor(*iConverterCore);

   conn0->setTarget();
   conn1->setTarget();
   conn2->setTarget();
   conn3->setTarget();
   return true;
}



