/*******************************************************************************
* FILE NAME: testdlg.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     testdlg- test dialog                                                     *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISPINNUM_
#include <ispinnum.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TESTDLG_
#include "testdlg.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for testdlgConn0
//*****************************************************************************
class testdlgConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testdlgConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IFrameWindow * target;


};   //testdlgConn0


//*****************************************************************************
// Class definition for testdlgConn1
//*****************************************************************************
class testdlgConn1 : public IObserver {
public:
   virtual  ~testdlgConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testdata * aSource, INumericSpinButton * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : testdata1(testvalue) to NumericSpinButton1(value))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setTestvalue(target->value());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : testdata1(testvalue) to NumericSpinButton1(value))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setValue(source->testvalue());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == testdata::testvalueId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testdata * source;
   INumericSpinButton * target;
   Boolean aligning;


};   //testdlgConn1


//*****************************************************************************
// Class definition for testdlgConn2
//*****************************************************************************
class testdlgConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testdlgConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, testdata * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to testdata1(customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      target->setTestvalue (target->testvalue() + 1);
      return;
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   testdata * target;


};   //testdlgConn2


#pragma export (testdlg::readyId)
const INotificationId testdlg::readyId = "testdlg::readyId";

#pragma export (testdlg::testdata1)
const INotificationId testdlg::testdata1 = "testdlg::testdata1";

#pragma export (testdlg::pushButton1ButtonClickEvent)
const INotificationId testdlg::pushButton1ButtonClickEvent = "testdlg::pushButton1ButtonClickEvent";

#pragma export (testdlg::testdata1Testvalue)
const INotificationId testdlg::testdata1Testvalue = "testdlg::testdata1Testvalue";

#pragma export (testdlg::partWindowId)
unsigned long testdlg::partWindowId = 0;

//------------------------------------------------------------------------------
// testdlg :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (testdlg::defaultFramingSpec())
const IRectangle testdlg::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 222),ISize(505, 222)));
}


//------------------------------------------------------------------------------
// testdlg :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (testdlg::defaultTitle())
IString testdlg::defaultTitle()
{
   return("Test dialog - Enter data");
}


//------------------------------------------------------------------------------
// testdlg :: testdlg
//------------------------------------------------------------------------------
#pragma export (testdlg::testdlg(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
testdlg::testdlg(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_testdlg_StaticText1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(33,132),ISize(120, 25)));
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_testdlg_PushButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(53,64),ISize(51, 34)));
   iNumericSpinButton1 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testdlg_NumericSpinButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(175,130),ISize(283, 29)));
   itestdata1 = new testdata();

   conn0 = new testdlgConn0();
   conn1 = new testdlgConn1();
   conn2 = new testdlgConn2();

   this->setFocus();
   this->setClient(iCanvas);
   iStaticText1->setText("Enter number:");
   iPushButton1->setText("OK");
}     //end constructor


//------------------------------------------------------------------------------
// testdlg :: ~testdlg
//------------------------------------------------------------------------------
#pragma export (testdlg::~testdlg())
testdlg::~testdlg()
{
   this->stopHandlingNotificationsFor(*itestdata1);
   this->stopHandlingNotificationsFor(*iPushButton1);
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*itestdata1);
   conn1->stopHandlingNotificationsFor(*iNumericSpinButton1);
   conn2->stopHandlingNotificationsFor(*iPushButton1);

   delete conn0;
   delete conn1;
   delete conn2;


   delete iCanvas;
   delete iStaticText1;
   delete iPushButton1;
   delete iNumericSpinButton1;
   delete itestdata1;
}

//------------------------------------------------------------------------------
// testdlg :: initializePart
//------------------------------------------------------------------------------
#pragma export (testdlg::initializePart())
testdlg & testdlg::initializePart()
{
   this->handleNotificationsFor(*itestdata1);
   this->handleNotificationsFor(*iPushButton1);
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// testdlg :: makeConnections
//------------------------------------------------------------------------------
#pragma export (testdlg::makeConnections())
Boolean testdlg::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iStaticText1->enableNotification();
   iPushButton1->enableNotification();
   iNumericSpinButton1->enableNotification();
   itestdata1->enableNotification();

   conn0->initialize(iPushButton1, this);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(itestdata1, iNumericSpinButton1);
   conn1->handleNotificationsFor(*itestdata1);
   conn1->handleNotificationsFor(*iNumericSpinButton1);
   conn2->initialize(iPushButton1, itestdata1);
   conn2->handleNotificationsFor(*iPushButton1);

   conn1->setTarget();
   return true;
}


//------------------------------------------------------------------------------
// testdlg :: dispatchNotificationEvent
//------------------------------------------------------------------------------
#pragma export (testdlg::dispatchNotificationEvent(const INotificationEvent &))
IObserver & testdlg::dispatchNotificationEvent(const INotificationEvent & anEvent)
{

   if ((anEvent.notificationId() == IPushButton::buttonClickId) && (iPushButton1 == &anEvent.notifier()))
       notifyObservers(INotificationEvent(pushButton1ButtonClickEvent, *this, anEvent.hasNotifierAttrChanged(), IEventData((void *)anEvent.eventData()), anEvent.observerData()));
   else
   if ((anEvent.notificationId() == testdata::testvalueId) && (itestdata1 == &anEvent.notifier()))
       notifyObservers(INotificationEvent(testdata1Testvalue, *this, anEvent.hasNotifierAttrChanged(), IEventData((void *)anEvent.eventData()), anEvent.observerData()));
   return *this;
}




