#ifndef _ISTDNTF2_
#define _ISTDNTF2_
/*******************************************************************************
* FILE NAME: istdntf2.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStandardNotifier2                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#include <inotify.hpp>

// TEMPORARY FOR THE PROTOTYPE.
#pragma library("stdntf2.LIB")

// Other dependency classes.
#ifndef _IANOTEV_
  #include <ianotev.hpp>
#endif

#ifndef _IEVTDATA_
  #include <ievtdata.hpp>
#endif

class IObserverList;
class IObserver;
class INotificationDispatcher;
class IThreadId;

#pragma pack(4)

class IStandardNotifier2 : public INotifier {
typedef INotifier
  Inherited;

public:
/*------------------------------ Constructors --------------------------------*/
  IStandardNotifier2 ( );
  IStandardNotifier2 ( const IStandardNotifier2& copy );
IStandardNotifier2
 &operator=          ( const IStandardNotifier2& aStandardNotifier2 );

virtual
 ~IStandardNotifier2 ( );

/*----------------------------- Async Deletion -------------------------------*/
// Use this function rather than the delete operator to asynchronously delete
// this object.
//   deleteAsync - Posts a notification to itself to safely delete itself.
//                 This function should be used instead of the delete operator
//                 when you wish to delete this object in response to one of
//                 its notifications.
void
  deleteAsync              ( );

/*-------------------------- Notification Members ----------------------------*/
virtual IStandardNotifier2
 &enableNotification       ( Boolean enable = true ),
 &disableNotification      ( );

virtual Boolean
  isEnabledForNotification ( ) const;

/*-------------------------- Observer Notification ---------------------------*/
// Either of these functions will dispatch the event on the same thread on
// which this object was created.  An isEnabledForNotification check is made
// both before and after any thread switch or queuing.  If this object is not
// enabled for notification at either check, the event is not dispatched.
//   notifyObservers      - Behaves the same as before (only faster) if called
//                          on the thread on which this object was created.
//                          If it is called from another thread, a synchronous
//                          thread switch and dispatch of the event is made.
//   notifyObserversAsync - Regardless of on what thread the call is made, the
//                          notification is queued for asynchronous dispatch.
//                          on the thread on which this object was created.
//                          This call returns before the event is dispatched.
//                          The event and its event data must not be local
//                          variables and can not be reliably referenced
//                          after the call is made.  This call adopts the
//                          event and will eventually delete it.
virtual IStandardNotifier2
 &notifyObservers          ( const INotificationEvent& anEvent ),
 &notifyObserversAsync     ( IAsyncNotificationEvent* anEvent );

/*----------------------------- Dispatch Thread ------------------------------*/
// Use this function to query the dispatch thread.
//   dispatchThread    - Returns the thread id for the dispatch thread.  This
//                       is the thread on which the object was created and on
//                       which all notifications will be dispatched.
const IThreadId
 &dispatchThread           ( ) const;

/*------------------------- Notification Event Ids ---------------------------*/
static INotificationId const
  IVB_IMPORT deleteId;


protected:
/*---------------------- Observer Addition and Removal -----------------------*/
virtual IStandardNotifier2
 &addObserver           ( IObserver&        observer,
                          const IEventData& userData = IEventData(0) ),
 &removeObserver        ( IObserver&  observer ),
 &removeAllObservers    ( );

// THIS FUNCTION THROWS AN EXCEPTION.
virtual IObserverList
 &observerList          ( ) const;

/*-------------------------- Observer Notification ---------------------------*/
virtual IStandardNotifier2
 &notifyObservers       ( const INotificationId& nId ),
 &notifyObserversAsync  ( const INotificationId& nId );


private:
/*--------------------------------- Private ----------------------------------*/
IObserverList
 &observerList2();

IObserverList*           fObservers;
Boolean                  fEnabled;
INotificationDispatcher* fDispatcher;

friend class INotificationDispatcher;
}; //IStandardNotifier2

#pragma pack()

#endif /* _ISTDNTF2_ */
