
# This file was generated by the SOM Compiler.
# FileName: clrpalet.sc.
# Generated using:
#     SOM Precompiler spc: 1.22
#     SOM Emitter emitcsc: 1.10

/*
 * 
 * MODULE NAME: ClrPalet.CSC
 * 
 * DESCRIPTION:
 *   Object class definition file for ColorPalette object class.
 */

#include "wpclrpal.sc"

class: ColorPalette, 
    external stem = clrp, local, external prefix = clrp_, 
    classprefix = clrpM_, major version = 1, minor version = 2, 
    file stem = clrpalet;

    -- 
    --  OBJECT CLASS: ColorPalette
    -- 
    --  CLASS HIERARCHY:
    -- 
    --      SOMObject
    --         WPObject
    --               WPAbstract
    --                     WPPalette
    --                            WPColorPalette
    --                     		        ColorPalette
    -- 
    --  DESCRIPTION:
    -- 	 This object class can act as a stand-alone object class that creates
    -- 	 a palette of named colors that can be dragged and dropped much like the
    -- 	 system color palette. It can also be used as a replacement object class
    -- 	 for the WPColorPalette class - thus replacing the color palette object
    -- 	 in the System Setup folder and any other color palettes that the user
    --    may have already created.
    -- 
    -- 	 Each element of the named color palette contains a sample swatch of the
    -- 	 color and the name of that color. Editing a color in the named color
    -- 	 palette invokes the Color Wheel control.
    -- 
    -- 	 The purpose of this class is to illustrate how the system provided
    -- 	 WPPalette object class works, and how the programmer can create his own
    --    customized palette of icons, menus, or any other sort of attribute that
    --    can be applied using drag and drop.
    -- 


parent class: WPColorPalette;


release order:
    SetEditDlgHandle, QueryEditDlgHandle, QuerySampleShape;


passthru: C.h, after;

endpassthru;
methods:


    BOOL    SetEditDlgHandle(HWND hwndEditDlg);

    -- 
    --  NEW METHOD: SetEditDlgHandle
    -- 
    --  DESCRIPTION:
    --    Store the handle of the color picking dialog window.
    -- 

    HWND    QueryEditDlgHandle();

    -- 
    --  NEW METHOD: QueryEditDlgHandle
    -- 
    --  DESCRIPTION:
    --    Retrieve the handle of the color picking dialog window. Return NULL
    --    if the dialog has not yet been created.
    -- 

    BOOL    QuerySampleShape(PPOINTL pPoints,
		PULONG pcPoints);

    -- 
    --  NEW METHOD: QuerySampleShape
    -- 
    --  DESCRIPTION:
    --    Describes the shape to be drawn for each color swatch. The pcPoints
    --    variable must always be filled out, to indicate how many points are
    --    contained in the pPoints array. pPoints either contains an array of
    --    POINTL structures that this method should fill out or it can be NULL
    --    to indicate that cPoints is being queried.
    -- 
    --    The point coordinates are specified in percentage coordinates.
    -- 

    override wpPaintCell;

    -- From WPPalette

    override wpEditCell;

    -- From WPPalette

    override wpRedrawCell;

    -- From WPPalette

    override wpSetup;

    -- From WPObject

    override wpclsInitData, class;

    -- From WPObject

    override wpclsQueryIconData, class;

    -- From WPObject

    override wpclsQueryStyle, class;

    -- From WPObject

