/* RCS      -- $Header: /u5/dvadura/src/public/dmake/src/os2/RCS/_chdir.c,v 1.1 1994/10/06 17:42:43 dvadura Exp $
-- SYNOPSIS -- Change directory.
-- 
-- DESCRIPTION
--	Under DOS change the current drive as well as the current directory.
--
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1992,1994 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log: _chdir.c,v $
 * Revision 1.1  1994/10/06  17:42:43  dvadura
 * dmake Release Version 4.0, Initial revision
 *
*/

#include <dos.h>
#include <os2.h>
#include "extern.h"

PUBLIC int
_chdir(path)
char *path;
{
   int res;

   res = chdir(path);

   if (res == 0 && path[1] == ':')
#ifdef OS2
      DosSelectDisk((*path & ~0x20) - '@');
#else
      unsigned new_drive;
      unsigned max_drives;

      new_drive = (*path & ~0x20) - 'A' + 1;
      _dos_setdrive(new_drive, &max_drives);
#endif

   return (res);
}
