/* $Id: prlocsym.c,v 1.15 2001/04/21 14:57:36 moniot Exp $

	Prints local symbol table, calling local checking routines along
	the way.

*/

/*
Copyright (C) 2000 by Robert K. Moniot.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
ROBERT K. MONIOT OR FORDHAM UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of ftnchek shall not be used
in advertising or otherwise to promote the sale, use or other dealings in
this Software without prior written authorization from the author.

*/

/*
	Shared functions defined:

		print_loc_symbols(curmodhash) Prints local symtab info.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "ftnchek.h"
#include "symtab.h"
#include "plsymtab.h"
#include "loccheck.h"

void
print_loc_symbols(VOID)
{
#ifdef DYNAMIC_TABLES		/* tables will be mallocked at runtime */
    static Lsymtab **sym_list=(Lsymtab **)NULL;
#else
    Lsymtab *sym_list[LOCSYMTABSZ]; /* temp. list of symtab entries to print */
#endif
    int	mod_type,		/* datatype of this module */
	this_is_a_function;	/* flag for treating funcs specially */
    Lsymtab *module;	 	/* entry of current module in symtab */
    char *mod_name;		/* module name */
    int
	imps=0,			/* count of implicitly declared identifiers */
	numentries;		/* count of entry points of module */

    if (dcl_fd == (FILE*)NULL)
	dcl_fd = stdout;

#ifdef DYNAMIC_TABLES
    if(sym_list == (Lsymtab **)NULL) { /* Initialize if not done before */
      if( (sym_list=(Lsymtab **)calloc(LOCSYMTABSZ,sizeof(Lsymtab *)))
	 == (Lsymtab **)NULL) {
	  oops_message(OOPS_FATAL,NO_LINE_NUM,NO_COL_NUM,
		       "Cannot malloc space for local symbol list");
      }
    }
#endif

				/* Keep track of statement counts
				   for -resource  */
    tot_exec_stmt_count += exec_stmt_count;
    if(exec_stmt_count > max_exec_stmt_count)
	max_exec_stmt_count = exec_stmt_count;

			/* Keep track of symbol table and string usage */
    if(loc_symtab_top > max_loc_symtab) {
	max_loc_symtab = loc_symtab_top;
    }
    if(loc_str_top + extra_locstrspace > max_loc_strings) {
	max_loc_strings = loc_str_top + extra_locstrspace;
    }
    if(srctextspace_top + extra_srctextspace > max_srctextspace) {
      max_srctextspace = srctextspace_top + extra_srctextspace;
    }
    if(token_head_space_top + extra_tokheadspace > max_tokenlists) {
      max_tokenlists=token_head_space_top + extra_tokheadspace;
    }
    if(param_info_space_top + extra_paraminfospace > max_paraminfo) {
      max_paraminfo=param_info_space_top + extra_paraminfospace;
    }
    if(token_space_top + extra_tokspace > max_token_space) {
	max_token_space = token_space_top + extra_tokspace;
    }
    if(ptrspace_top + extra_ptrspace > max_ptrspace) {
      max_ptrspace = ptrspace_top + extra_ptrspace;
    }

    update_label_resources();	/* Do the same in label handler */

			/* Global symbols only increase in number */
    max_glob_symtab = glob_symtab_top;


		/* Set up name & type, and see what kind of module it is */

	      module = hashtab[current_module_hash].loc_symtab;

	      mod_name = module->name;
	      mod_type = get_type(module);

	      if(  mod_type != type_PROGRAM
		&& mod_type != type_SUBROUTINE
		&& mod_type != type_COMMON_BLOCK
		&& mod_type != type_BLOCK_DATA )
			this_is_a_function = TRUE;
	      else
			this_is_a_function = FALSE;

				/* Print name & type of the module */
    if(do_symtab) {
      int i;
      for(i=0,numentries=0;i<loc_symtab_top;i++) {
	if(loc_symtab[i].entry_point)
	  sym_list[numentries++] = &loc_symtab[i];
      }

	   if(numentries > 1) {
	      sort_lsymbols(sym_list,numentries);
	   }


	  (void)fprintf(list_fd,"\n\nModule %s:",mod_name);
	  if( this_is_a_function ) (void)fprintf(list_fd," func:");
	  (void)fprintf(list_fd," %4s",type_name[mod_type]);
			/* Print a * next to non-declared function name */
	  if(datatype_of(module->type) == type_UNDECL ) {
			(void)fprintf(list_fd,"*");
			imps++;
	  }
	  (void)fprintf(list_fd,"\n");


				/* Print Entry Points (skip if only one,
				   since it is same as module name) */
      if(do_symtab && numentries > 1) {
	      (void)fprintf(list_fd,"\nEntry Points\n");
	      (void) print_lsyms_briefly(list_fd,sym_list,numentries,FALSE);
      }

			/* End of printing module name and entry points */
    }/*if(do_symtab)*/



				/* Print the externals */

    if(do_symtab) {
	int i,n;
	for(i=0,n=0;i<loc_symtab_top;i++) {
	    if(storage_class_of(loc_symtab[i].type) == class_SUBPROGRAM) {
		  sym_list[n++] = &loc_symtab[i];
	    }
	}
	if(n != 0) {
	      sort_lsymbols(sym_list,n);

	      if (do_symtab)
	      {
		  (void)fprintf(list_fd,"\nExternal subprograms referenced:\n");
		  imps += print_lsyms_briefly(list_fd,sym_list,n,TRUE);
	      }
	}

      }/*if(do_symtab)*/


				/* Print list of statement functions */
    if(do_symtab || usage_ext_unused) {
	   int i,n;

	   for(i=0,n=0;i<loc_symtab_top;i++) {
	       if(storage_class_of(loc_symtab[i].type) == class_STMT_FUNCTION){
		  sym_list[n++] = &loc_symtab[i];
	       }
	   }
	   if(n != 0) {
	      sort_lsymbols(sym_list,n);
	      if(do_symtab) {
		(void)fprintf(list_fd,"\nStatement functions defined:\n");
		imps += print_lsyms_briefly(list_fd,sym_list,n,TRUE);
	      }
				/* Note: unused stmt functions are "set"
				   when parsed in assignment stmt, so pattern
				   to look for is !used, set, !ubs
				 */
	      if(usage_ext_unused) {
		check_flags(sym_list,n,0,1,0,
		 "Statement functions defined but never referenced:",mod_name);
	      }
	    }
    }/*if(do_symtab)*/


				/* Print the common blocks */
    if(do_symtab || port_common_alignment || f77_mixed_common) {
	   int i,numblocks;

	   for(i=0,numblocks=0;i<loc_symtab_top;i++) {
	      if(storage_class_of(loc_symtab[i].type) == class_COMMON_BLOCK) {
		  sym_list[numblocks++] = &loc_symtab[i];
	      }
	   }

	   if(numblocks != 0) {
	      sort_lsymbols(sym_list,numblocks);
	      if(do_symtab) {
		  (void)fprintf(list_fd,"\nCommon blocks referenced:\n");
		  (void) print_lsyms_briefly(list_fd,sym_list,numblocks,FALSE);
	      }
	      if(port_common_alignment || f77_mixed_common) {
		    check_mixed_common(list_fd,sym_list,numblocks);
	      }
	   }
     }/*if(do_symtab||port_common_alignment||f77_mixed_common)*/

				/* Print the namelists */
    if(do_symtab) {
	   int i,numlists;

	   for(i=0,numlists=0;i<loc_symtab_top;i++) {
	      if(storage_class_of(loc_symtab[i].type) == class_NAMELIST) {
		  sym_list[numlists++] = &loc_symtab[i];
	      }
	   }

	   if(numlists != 0) {
	      sort_lsymbols(sym_list,numlists);
	      if(do_symtab) {
		  (void)fprintf(list_fd,"\nNamelists defined:\n");
		  (void) print_lsyms_briefly(list_fd,sym_list,numlists,FALSE);
	      }
	    }

    }/* End printing the namelists */

				/* Process the variables */

    if(do_symtab || pure_functions
       || (usage_var_set_unused || usage_var_uninitialized
       || usage_var_unused || usage_arg_unused)) {
	int i,n;

	for(i=0,n=0;i<loc_symtab_top;i++) {
	       if(storage_class_of(loc_symtab[i].type) == class_VAR
	       && (!loc_symtab[i].entry_point || this_is_a_function)) {
		  sym_list[n++] = &loc_symtab[i];
	       }
	}
	if(n != 0) {

	   sort_lsymbols(sym_list,n);

	   if(this_is_a_function && pure_functions) {
	       check_nonpure(sym_list,n,mod_name);
	   }

			/* Print the variables */

	   if(do_symtab) {
	      (void)fprintf(list_fd,"\nVariables:\n ");
	      imps += print_variables(sym_list,n);
	   }
	}
			/* Explain the asterisk on implicitly defined
			   identifiers.  Note that this message will
			   be given also if functions implicitly defined */
	if(do_symtab && imps != 0) {
	     (void)fprintf(list_fd,"\n* Variable not declared.");
	     (void)fprintf(list_fd," Type has been implicitly defined.");
	     ++warning_count;
	}

	if(usage_var_unused || usage_arg_unused
	   || usage_var_set_unused || usage_var_uninitialized) {
	  if(do_symtab || do_list)
	    (void)fprintf(list_fd,"\n");
	  if(usage_var_unused || usage_arg_unused) {
	    check_flags(sym_list,n,0,0,0,
		      "Variables declared but never referenced:",mod_name);
	  }
	  if(usage_var_set_unused) {
	    check_flags(sym_list,n,0,1,0,
		      "Variables set but never used:",mod_name);
	  }
	  if(usage_var_uninitialized) {
	    check_flags(sym_list,n,1,0,1,
		      "Variables used before set",mod_name);
	    check_flags(sym_list,n,1,1,1,
		      "Variables may be used before set:",mod_name);
	  }

	}/*end if(usage_...)*/

	if(do_symtab || do_list)
	  (void)fprintf(list_fd,"\n");

    }/* end if(do_symtab || pure_functions || usage_...) */

			/* List all undeclared vars & functions */
    if(decls_required || implicit_none) {
	int i,n;

	for(i=0,n=0;i<loc_symtab_top;i++) {
	    if(datatype_of(loc_symtab[i].type) == type_UNDECL
		&& ! loc_symtab[i].intrinsic /* omit intrinsics */
				/* omit subroutines called */
		&& (!loc_symtab[i].external || loc_symtab[i].invoked_as_func)
	       ) {
		sym_list[n++] = &loc_symtab[i];
	    }
	}
	if(n != 0) {
	    sort_lsymbols(sym_list,n);
	    local_warn_head(mod_name,
			   top_filename,
			   NO_LINE_NUM, sym_list[0], FALSE,
				"Identifiers of undeclared type");
	    (void) print_lsyms(list_fd,sym_list,n,FALSE);
	}
    }/*if(decls_required || implicit_none)*/

			/* Under -f77/f90, list any nonstandard intrinsics used */
    if(f77_intrinsics || f90_intrinsics) {
      int i,n;
      for(i=0,n=0;i<loc_symtab_top;i++) {
	if(storage_class_of(loc_symtab[i].type) == class_SUBPROGRAM
	   && loc_symtab[i].intrinsic &&
	   (loc_symtab[i].info.intrins_info->intrins_flags & (f77_intrinsics?I_NONF77:I_NONF90))) {
	  sym_list[n++] = &loc_symtab[i];
	}
      }

      if(n != 0) {
	sort_lsymbols(sym_list,n);
	local_warn_head(mod_name,
			choose_filename(sym_list[0],file_used),
			sym_list[0]->line_used, 
			(Lsymtab *)NULL, FALSE,
			f77_intrinsics? "Non Fortran 77" : "Non Fortran 90");
	msg_tail("intrinsic functions referenced:");
	(void) print_lsyms(list_fd,sym_list,n,FALSE);
      }
    }/*if(f77_intrinsics || f90_intrinsics)*/


		/* issue -f77 warning for identifiers
		   longer than 6 characters
		*/
    if(f77_long_names) {
	int i,n;
	for(i=0,n=0;i<loc_symtab_top;i++) {
	       if(strlen(loc_symtab[i].name) > (unsigned)6)
		  sym_list[n++] = &loc_symtab[i];
	}

	if(n != 0) {

	   sort_lsymbols(sym_list,n);

	   local_warn_head(mod_name,
			  top_filename,
			  NO_LINE_NUM, sym_list[0], FALSE,
			       "Names longer than 6 chars (nonstandard):");
	   (void) print_lsyms(list_fd,sym_list,n,FALSE);
	}
    }

	/* If -f77 flag given, list names with underscore or dollarsign */

    if(f77_underscores || f77_dollarsigns || f90_dollarsigns) {
	int n;
	n = find_nonalnum_names(sym_list);

	if(n != 0) {

	   sort_lsymbols(sym_list,n);

	   local_warn_head(mod_name,
			  top_filename,
			  NO_LINE_NUM, sym_list[0], FALSE,
			       "Names containing nonstandard characters:");
	   (void) print_lsyms(list_fd,sym_list,n,FALSE);
	}
    }/*if(f77_underscores || f77_dollarsigns || f90_dollarsigns)*/

			/* Print out clashes in first six chars of name */
    if(sixclash) {
	 int n;
	 n = find_sixclashes(sym_list);
	 if(n != 0) {
	    sort_lsymbols(sym_list,n);
				/* Use the right line number */
	    local_warn_head(mod_name,
			   top_filename,
			   NO_LINE_NUM, sym_list[0], FALSE,
		      "Identifiers which are not unique in first six chars:");
	    (void) print_lsyms(list_fd,sym_list,n,FALSE);
	 }/* end if(n != 0) */
    }/* end if(sixclash) */


		/* If portability flag was given, check equivalence
		   groups for mixed type. */
    if(port_mixed_equiv || port_mixed_size || local_wordsize==0) {
	int i,j,n;
	int port_imps=0;
	Lsymtab *equiv;

		/* scan thru table for equivalenced variables */
	for(i=0;i<loc_symtab_top;i++) {
	    if(storage_class_of(loc_symtab[i].type) == class_VAR
	       && loc_symtab[i].equiv_link != (equiv= &loc_symtab[i]) ){
		n=0;
		do {
		    if(equiv < &loc_symtab[i]) { /* skip groups done before */
			n=0;
			break;
		    }
		    sym_list[n++] = equiv;
		    equiv = equiv->equiv_link;
		} while(equiv != &loc_symtab[i]); /* complete the circle */
				/* Check for mixed types */
		if(n != 0) {
		    int mixed_type = FALSE, mixed_size = FALSE,
			mixed_default_size = FALSE;
		    int t1,t2,s1,s2,defsize1,defsize2;

		    t1 = get_type(sym_list[0]);
		    s1 = get_size(sym_list[0],t1);
		    defsize1 = (s1 == size_DEFAULT);
		    if(s1 == size_DEFAULT) s1 = type_size[t1];
		    for(j=1; j<n; j++) {
		      t2 = get_type(sym_list[j]);
		      s2 = get_size(sym_list[j],t2);
		      defsize2 = (s2 == size_DEFAULT);
		      if(s2 == size_DEFAULT) s2 = type_size[t2];
		      if( t1 == t2 ) {
			if( t1 != type_STRING ){
				/* Same non-char types: size must match */
			  if( s1 != s2 ) {
			    mixed_size = TRUE;
			    break;
			  }
			  else if(defsize1 != defsize2) {
			    mixed_default_size = TRUE;
			    break;
			  }
			}
		      }
		      else {/* Different types */
				/* It is nonportable to equivalence:
					 Real*8 to Double or
					 Complex*16 to DComplex */
			if(type_category[t1] == type_category[t2]) {
			  if( s1 != s2 ) {
			    mixed_size = TRUE;
			    break;
			  }
			  else if(defsize1 != defsize2) {
			    mixed_default_size = TRUE;
			    break;
			  }
			}
				/* It is standard and portable to equivalence:
					 Real to Complex or
					 Double to DComplex */
			else if(equiv_type[t1] == equiv_type[t2]) {
			  if( ((type_category[t1] == type_COMPLEX)?
				s1 != 2*s2: s2 != 2*s1) ) {
			    mixed_size = TRUE;
			    break;
			  }
			  else if(defsize1 != defsize2) {
			    mixed_default_size = TRUE;
			    break;
			  }
			}
			else {
			  mixed_type = TRUE;
			  break;
			}
		      }/*end else different types*/

		      t1 = t2;
		      s1 = s2;
		      defsize1 = defsize2;
		    }/*end for j*/

		    if( (mixed_type && port_mixed_equiv) ||
		       ((mixed_size || mixed_default_size) &&
			(port_mixed_size || local_wordsize==0)) )  {
			sort_lsymbols(sym_list,n);
			local_warn_head(mod_name,
					top_filename,
					NO_LINE_NUM, sym_list[0], 
					FALSE, "Mixed");
			if(mixed_type)
			    msg_tail("types");
			else if(mixed_size)
			    msg_tail("sizes");
			else
			    msg_tail("default and explicit size items");
			msg_tail("equivalenced (not portable):");
			port_imps += print_lsyms(list_fd,sym_list
					   ,n,TRUE);
		    }
		}
	    }
	}
	if(brief && port_imps != 0) {
	     (void)fprintf(list_fd,"\n* Variable not declared.");
	     (void)fprintf(list_fd," Type has been implicitly defined.\n");
	}

    }/*if(port_mixed_size/type)*/

					/* print table of stmt labels */

    if(misc_warn || usage_label_undefined || usage_label_unused
       || do_symtab || print_lab_refs) {
	sort_labtable();
	if(do_symtab) {
	    print_labels();
	}
	if(print_lab_refs) {
	    print_label_refs();
	}
	if(misc_warn || usage_label_undefined || usage_label_unused) {
	    check_labels(mod_name);
	}
    }

    make_declarations(sym_list,mod_name);
}/* print_loc_symbols */










